/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.EQTL;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.UberonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JaxEQTLReader<N extends Entity>
extends LineIteratorReader<N> {
    private static Logger logger = LoggerFactory.getLogger(JaxEQTLReader.class);
    private static UberonService uberonService = new UberonService();
    private List<String> headerNames;
    private Map<String, Object> headerValues;
    private static Map<String, String> studyIdMap = JaxEQTLReader.createStudyIdMap();
    private DateFormat format1 = new SimpleDateFormat("MM/dd/yyyy");
    private DateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");

    JaxEQTLReader() {
    }

    @Override
    public JaxEQTLReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter(",");
        return this;
    }

    @Override
    protected N create(String line) throws ReaderException {
        if (this.headerNames == null || this.headerValues == null) {
            this.parseHeaders();
        }
        EQTL bean = new EQTL();
        bean.setTissueFileName(this.request.name());
        BeanMap d = new BeanMap((Object)bean);
        String[] values = line.split(this.getDelimiter());
        if (values.length != this.headerNames.size()) {
            throw new ReaderException("There are a different number of headers and values!");
        }
        for (int i = 0; i < this.headerNames.size(); ++i) {
            String name = this.headerNames.get(i);
            Object value = values[i];
            if (value == null) continue;
            value = values[i].trim();
            Class type = d.getType(name);
            if (("NA".equalsIgnoreCase(value.toString()) || "null".equalsIgnoreCase(value.toString())) && Number.class.isAssignableFrom(type)) {
                value = "0";
            }
            if (Integer.class.equals((Object)type)) {
                value = Double.valueOf(value.toString()).intValue();
            } else if (Double.class.equals((Object)type)) {
                value = Double.valueOf(value.toString());
            }
            try {
                if (value.toString().length() < 1) continue;
                d.put((Object)name, value);
                continue;
            }
            catch (NumberFormatException ne) {
                logger.info("The property '" + name + "' cannot have value: " + values[i]);
                continue;
            }
            catch (IllegalArgumentException ie) {
                throw new ReaderException("Field " + name + " has type " + String.valueOf(type) + " which has not been parsed from " + String.valueOf(value));
            }
        }
        this.headerValues.forEach((k, v) -> d.put(k, v));
        return (N)bean;
    }

    private static Map<String, String> createStudyIdMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Aging_Bone_DO.csv.gz".toLowerCase(), "Project999901");
        ret.put("Aging_Heart_DO.csv.gz".toLowerCase(), "Project999902");
        ret.put("Aging_Kidney_DO.csv.gz".toLowerCase(), "Project999903");
        ret.put("Chesler_Hippocampus_DO.csv.gz".toLowerCase(), "Chesler999901");
        ret.put("Chesler_Striatum_DO.csv.gz".toLowerCase(), "Chesler999902");
        ret.put("DO.Cube.Adipose.csv.gz".toLowerCase(), "Cube999901");
        ret.put("DO.Cube.Heart.csv.gz".toLowerCase(), "Cube999902");
        ret.put("DO.Cube.Islet.csv.gz".toLowerCase(), "Cube999903");
        ret.put("DO.Cube.Liver.csv.gz".toLowerCase(), "Cube999904");
        ret.put("DO.Cube.SkeletalMuscle.csv.gz".toLowerCase(), "Cube999905");
        ret.put("Skelly_mESC_DO.csv.gz".toLowerCase(), "Skelly999901");
        ret.put("Svenson_HFD_DO.csv.gz".toLowerCase(), "Svenson999901");
        return ret;
    }

    private String createFudgedStudyId(String name) throws ReaderException {
        if (name == null) {
            return null;
        }
        try {
            if (studyIdMap.containsKey(name.toLowerCase())) {
                return studyIdMap.get(name.toLowerCase());
            }
            return "Project:" + Base64.getEncoder().encodeToString(name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ReaderException(e);
        }
    }

    @Override
    protected Map<String, Object> parseHeaders() throws ReaderException {
        int i;
        if (this.header == null || this.header.isEmpty()) {
            throw new ReaderException("JAX eQTL files must have a header!");
        }
        String headLine = (String)this.header.get(this.header.size() - 1);
        String[] names = headLine.substring(1).split(this.getDelimiter());
        this.headerNames = new ArrayList<String>();
        for (i = 0; i < names.length; ++i) {
            String name = names[i];
            if ((name = name.replace("_", "")).equals("rsid")) {
                name = "rsId";
            }
            if (name.equals("geneid")) {
                name = "geneId";
            }
            if (name.equals("bpmm10")) {
                name = "bp";
            }
            if (name.equals("bpm39")) {
                name = "bpGRCm39";
            }
            if (name.equals("strain")) {
                name = "population";
            }
            this.headerNames.add(name);
        }
        this.headerValues = new HashMap<String, Object>();
        for (i = 0; i < this.header.size() - 1; ++i) {
            String hline = ((String)this.header.get(i)).substring(1).trim();
            String[] kvs = hline.split(":");
            if (kvs.length != 2) {
                logger.debug("Ignored invalid header line: " + hline);
                continue;
            }
            String name = kvs[0].toLowerCase();
            if (name.indexOf(32) > 0) continue;
            Object value = kvs[1].trim();
            if (name.equals("strain")) {
                name = "population";
            }
            if (name.equals("ensembl.version")) {
                name = "version";
            }
            if (name.equals("tissue")) {
                name = "tissueName";
                value = value.toString().toLowerCase();
            }
            if (name.equals("species")) continue;
            if (name.equals("url")) {
                name = "source";
            }
            if (name.equals("date")) {
                try {
                    value = this.format1.parse(value.toString());
                    continue;
                }
                catch (ParseException e) {
                    try {
                        value = this.format2.parse(value.toString());
                        continue;
                    }
                    catch (ParseException eOther) {
                        throw new ReaderException("Cannot parse date: " + String.valueOf(value));
                    }
                }
            }
            this.headerValues.put(name, value);
        }
        if (this.headerValues.containsKey("tissueName")) {
            String tName = this.headerValues.get("tissueName").toString();
            this.headerValues.put("uberon", uberonService.getUberonCode(tName));
        }
        return this.headerValues;
    }

    @Override
    protected void addHeader(String line) {
        this.headerNames = null;
        this.headerValues = null;
        super.addHeader(line);
    }
}

