/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.geneweaver.domain.EQTL;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JaxIntervalEQTLReader
extends LineIteratorReader<EQTL> {
    private static Logger logger = LoggerFactory.getLogger(JaxIntervalEQTLReader.class);
    private List<String> headerNames;
    private Map<String, Object> headerValues;
    private List<String> ignoredColumns = Arrays.asList("1p5lod", "inpaper");
    private DateFormat format1 = new SimpleDateFormat("MM/dd/yyyy");
    private DateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");

    JaxIntervalEQTLReader() {
    }

    @Override
    public JaxIntervalEQTLReader init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter(",");
        return this;
    }

    @Override
    protected EQTL create(String line) throws ReaderException {
        if (this.headerNames == null || this.headerValues == null) {
            this.parseHeaders();
        }
        EQTL bean = new EQTL();
        bean.setTissueFileName(this.request.name());
        bean.setStudyId(this.createFudgedStudyId(this.request.name(), this.headerValues));
        bean.setType(EQTL.Type.INTERVAL);
        BeanMap d = new BeanMap((Object)bean);
        String[] values = line.split(this.getDelimiter());
        if (values.length != this.headerNames.size()) {
            throw new ReaderException("There are a different number of headers and values!");
        }
        for (int i = 0; i < this.headerNames.size(); ++i) {
            Object value;
            String name = this.headerNames.get(i);
            if (this.ignoredColumns.contains(name.toLowerCase()) || (value = values[i]) == null) continue;
            value = values[i].trim();
            Class type = d.getType(name);
            if ("NA".equals(value) && Number.class.isAssignableFrom(type)) {
                value = "0";
            }
            if (Integer.class.equals((Object)type)) {
                value = Double.valueOf(value.toString()).intValue();
            } else if (Double.class.equals((Object)type)) {
                value = Double.valueOf(value.toString());
            }
            try {
                if (value.toString().length() < 1) continue;
                d.put((Object)name, value);
                continue;
            }
            catch (NumberFormatException ne) {
                logger.info("The property '" + name + "' cannot have value: " + values[i]);
                continue;
            }
            catch (IllegalArgumentException ie) {
                throw new ReaderException("Field " + name + " has type " + String.valueOf(type) + " which has not been parsed from " + String.valueOf(value));
            }
        }
        this.headerValues.forEach((k, v) -> d.put(k, v));
        return bean;
    }

    private String createFudgedStudyId(String name, Map<String, Object> headerValues) throws ReaderException {
        if (name == null) {
            return null;
        }
        try {
            if (headerValues.containsKey("studyId")) {
                return headerValues.get("studyId").toString();
            }
            return "Project:" + Base64.getEncoder().encodeToString(name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ReaderException(e);
        }
    }

    @Override
    protected Map<String, Object> parseHeaders() throws ReaderException {
        int i;
        if (this.header == null || this.header.isEmpty()) {
            throw new ReaderException("JAX eQTL files must have a header!");
        }
        String headLine = (String)this.header.get(this.header.size() - 1);
        String[] names = headLine.substring(1).split(this.getDelimiter());
        this.headerNames = new ArrayList<String>();
        for (i = 0; i < names.length; ++i) {
            String name = names[i];
            name = name.replace("_", "");
            String lc = (name = name.replace(" ", "")).toLowerCase();
            if (lc.equals("rsid")) {
                name = "rsId";
            }
            if (lc.equals("rid")) {
                name = "rsId";
            }
            if (lc.equals("geneid")) {
                name = "geneId";
            }
            if (lc.equals("genename")) {
                name = "geneName";
            }
            if (lc.equals("bpmm10")) {
                name = "bp";
            }
            if (lc.equals("bpm39")) {
                name = "bpGRCm39";
            }
            this.headerNames.add(name);
        }
        this.headerValues = new HashMap<String, Object>();
        for (i = 0; i < this.header.size() - 1; ++i) {
            String hline = ((String)this.header.get(i)).substring(1);
            String[] kvs = hline.split(":");
            String name = kvs[0].toLowerCase().trim();
            name = name.replace("_", "");
            name = name.replace(" ", "");
            Object value = kvs[1].trim();
            if (name.equals("ensembl.version")) {
                name = "version";
            }
            if (name.equals("tissue")) {
                name = "tissueName";
                value = value.toString().toLowerCase();
            }
            if (name.equals("studyid")) {
                name = "studyId";
            }
            if (name.equals("rsid")) {
                name = "rsId";
            }
            if (name.equals("rid")) {
                name = "rsId";
            }
            if (name.equals("geneid")) {
                name = "geneId";
            }
            if (name.equals("genename")) {
                name = "geneName";
            }
            if (name.equals("bpmm10")) {
                name = "bp";
            }
            if (name.equals("bpmm39")) {
                name = "bpGRCm39";
            }
            if (name.equals("species")) continue;
            if (name.equals("url")) {
                name = "source";
            }
            if (name.equals("date")) {
                try {
                    value = this.format1.parse(value.toString());
                    continue;
                }
                catch (ParseException e) {
                    try {
                        value = this.format2.parse(value.toString());
                        continue;
                    }
                    catch (ParseException eOther) {
                        throw new ReaderException("Cannot parse date: " + String.valueOf(value));
                    }
                }
            }
            this.headerValues.put(name, value);
        }
        return this.headerValues;
    }

    @Override
    protected void addHeader(String line) {
        this.headerNames = null;
        this.headerValues = null;
        super.addHeader(line);
    }

    @Override
    public Stream<EQTL> stream() {
        return super.stream().flatMap(n -> this.expand((EQTL)n));
    }

    private Stream<EQTL> expand(EQTL n) {
        if (!(n instanceof EQTL)) {
            return Stream.of(n);
        }
        EQTL eqtl = n;
        String rid = eqtl.getRsId();
        if (rid.startsWith("rs") && rid.indexOf(32) > -1) {
            String[] rids = rid.split("\\s+");
            return Stream.of(rids).map(r -> this.clone((String)r, eqtl));
        }
        return Stream.of(n);
    }

    private EQTL clone(String rsId, EQTL eqtl) {
        EQTL ret = new EQTL();
        try {
            BeanUtils.copyProperties((Object)ret, (Object)eqtl);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot copy properties of EQTL for variant " + rsId);
        }
        ret.setRsId(rsId);
        return ret;
    }
}

