/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Species;
import org.geneweaver.io.reader.AbstractStreamReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.StreamUtil;

public abstract class LineIteratorReader<T extends Entity>
extends AbstractStreamReader<T>
implements Spliterator<T> {
    private static final long build = LineIteratorReader.generateBuildNumber();
    protected Iterator<String> iterator;
    protected volatile int count;
    private String windStopType;
    private String rejectedLine;
    private String delimiter = System.getProperty("org.geneweaver.io.delimiter", "\\s+");
    private String comment = "#";
    protected List<String> header;
    private String assignmentChar = " ";
    private Pattern quotedRegex;

    protected void setup(ReaderRequest request) throws ReaderException {
        if (request.getDelimiter() != null) {
            this.setDelimiter(request.getDelimiter());
        }
        try {
            super.init(request);
            this.iterator = request.isNoInputStream() ? null : StreamUtil.createStream(request);
            this.count = 0;
        }
        catch (IOException ne) {
            throw new ReaderException(ne);
        }
    }

    protected LineIteratorReader() {
    }

    @Override
    public Stream<T> stream() {
        this.header = null;
        if (this.isEmpty() && this.isDataSource()) {
            try {
                this.iterator = StreamUtil.createStream(this.request.getFile(), this.request.isCloseInputStream());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("The scanner iterator cannot be recreated from " + String.valueOf(this.request.getFile()), e);
            }
        }
        return StreamSupport.stream(this, false);
    }

    private static long generateBuildNumber() {
        LocalDateTime now = LocalDateTime.now();
        String format = now.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss", Locale.ENGLISH));
        return Long.parseLong(format);
    }

    protected abstract T create(String var1) throws ReaderException;

    protected String getAssignmentChar() {
        return this.assignmentChar;
    }

    protected String setAssignmentChar(String ac) {
        String curChar = this.assignmentChar;
        this.assignmentChar = ac;
        return curChar;
    }

    protected Object transfer(String propName, Map<String, String> from, String attrName, Map<Object, Object> to) {
        Set<Object> fields;
        if (from.containsKey(propName) && (fields = to.keySet()).contains(attrName)) {
            return to.put(attrName, from.get(propName));
        }
        return null;
    }

    public long getBuild() {
        return build;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 4[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void rejectLine(String line) {
        this.rejectedLine = line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String nextLine() {
        if (this.rejectedLine != null) {
            String ret = this.rejectedLine;
            this.rejectedLine = null;
            return ret;
        }
        String line = null;
        try {
            if (!this.iterator.hasNext()) {
                String string = line;
                return string;
            }
            line = this.iterator.next();
            if (line == null) {
                String string = line;
                return string;
            }
            if (!(line = line.trim()).startsWith(this.comment)) {
                ++this.count;
            }
            while ((line.isEmpty() || line.startsWith(this.comment)) && this.iterator.hasNext()) {
                if (line.startsWith(this.comment)) {
                    this.addHeader(line);
                }
                if ((line = this.iterator.next()) == null) {
                    String string = line;
                    return string;
                }
                if ((line = line.trim()).startsWith(this.comment)) continue;
                ++this.count;
            }
            if (line.isEmpty()) {
                line = null;
            }
            String string = line;
            return string;
        }
        catch (IllegalArgumentException | IllegalStateException | IndexOutOfBoundsException i) {
            String string = null;
            return string;
        }
        finally {
            if (line == null && this.iterator instanceof Closeable) {
                try {
                    if (this.request.isCloseInputStream()) {
                        ((Closeable)((Object)this.iterator)).close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("The scanner closeable cannot close!", e);
                }
            }
        }
    }

    protected void addHeader(String line) {
        if (this.header == null) {
            this.header = new LinkedList<String>();
        }
        this.header.add(line);
    }

    @Override
    public Spliterator<T> trySplit() {
        try {
            if (!this.iterator.hasNext()) {
                return null;
            }
        }
        catch (IllegalArgumentException | IllegalStateException | IndexOutOfBoundsException i) {
            return null;
        }
        Spliterator<String> split = this.wind(this.chunkSize).spliterator();
        LineWrapper wrapper = new LineWrapper(split);
        return wrapper;
    }

    @Override
    public List<T> wind() throws ReaderException {
        List<String> lines = this.wind(this.getChunkSize());
        LinkedList<T> items = new LinkedList<T>();
        for (String line : lines) {
            T bean = this.create(line);
            if (bean == null) continue;
            items.add(bean);
        }
        return items;
    }

    private synchronized List<String> wind(int amount) {
        LinkedList<String> ls = new LinkedList<String>();
        String line = null;
        for (int i = 0; i < amount && (line = this.nextLine()) != null; ++i) {
            ls.add(line);
        }
        if (line != null && this.getWindStopType() != null) {
            while ((line = this.nextLine()) != null) {
                String[] rec = line.split("\t");
                String type = rec[2];
                if (!this.getWindStopType().equals(type.toLowerCase())) {
                    ls.add(line);
                    continue;
                }
                this.rejectLine(line);
                break;
            }
        }
        return ls;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator.hasNext();
    }

    @Override
    public long estimateSize() {
        if (this.request.getFile() == null) {
            return 10000L;
        }
        String typical = "1\thavana\ttranscript\t11869\t14409\t.\t+\t.\tgene_id \"ENSG00000223972\"; gene_version \"5\"; transcript_id \"ENST00000456328\"; transcript_version \"2\"; gene_name \"DDX11L1\"; gene_source \"havana\"; gene_biotype \"transcribed_unprocessed_pseudogene\"; transcript_name \"DDX11L1-202\"; transcript_source \"havana\"; transcript_biotype \"processed_transcript\"; tag \"basic\"; transcript_support_level \"1\"; cannot be parsed ";
        int bytesPerLine = typical.getBytes().length;
        return this.request.getFile().length() / (long)bytesPerLine;
    }

    @Override
    public int characteristics() {
        return 1040;
    }

    @Override
    public int linesProcessed() {
        return this.count;
    }

    protected void populateStandardColumns(BeanMap d, String[] rec) {
        Object chr = rec[0];
        if (!((String)chr).startsWith("chr")) {
            chr = "chr" + (String)chr;
        }
        d.put((Object)"chr", chr);
        d.put((Object)"source", (Object)rec[1]);
        d.put((Object)"type", (Object)rec[2]);
        d.put((Object)"start", (Object)rec[3]);
        d.put((Object)"end", (Object)rec[4]);
    }

    protected void populate(BeanMap d, String[] rec) {
        d.put((Object)"sequenceId", (Object)rec[0]);
        this.populateStandardColumns(d, rec);
        d.put((Object)"score", (Object)rec[5]);
        d.put((Object)"strand", (Object)rec[6]);
        if (rec[6].length() > 8) {
            d.put((Object)"strand", (Object)rec[6].substring(0, 8));
        }
        d.put((Object)"active", (Object)Boolean.TRUE);
        d.put((Object)"build", (Object)this.getBuild());
        d.put((Object)"species", (Object)this.getSpecies());
    }

    protected Map<String, String> parseAttributes(String rec8) {
        String[] attr = rec8.split(";");
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < attr.length; ++i) {
            String line = attr[i].trim().replace("\"", "");
            String[] kv = line.split(this.getAssignmentChar());
            if (kv.length != 2) continue;
            attributes.put(kv[0], kv[1].trim());
        }
        return attributes;
    }

    protected Map<String, String> parseQuotedAttributes(String ln) {
        if (this.quotedRegex == null) {
            String regex = "([a-zA-Z0-9_\\-\\.]+)" + this.getAssignmentChar() + "\"([a-zA-Z0-9_\\-\\. ]+)\"";
            this.quotedRegex = Pattern.compile(regex);
        }
        Matcher matcher = this.quotedRegex.matcher(ln);
        HashMap<String, String> attributes = new HashMap<String, String>();
        while (matcher.find()) {
            String key = matcher.group(1);
            String val = matcher.group(2);
            attributes.put(key, val.trim());
        }
        return attributes;
    }

    @Override
    public void close() throws IOException {
        this.request.close();
    }

    private String getWindStopType() {
        return this.windStopType;
    }

    protected void setWindStopType(String windStopType) {
        this.windStopType = windStopType;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getSpecies() {
        if (this.request == null) {
            return null;
        }
        String species = this.request.getSource();
        return Species.code(species);
    }

    @Override
    public boolean isDataSource() {
        return this.request.isFileRequest();
    }

    protected String getComment() {
        return this.comment;
    }

    protected void setComment(String comment) {
        this.comment = comment;
    }

    protected Map<String, Object> parseHeaders() throws ReaderException {
        if (this.header == null || this.header.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String line : this.header) {
            if ((line = line.trim()).startsWith("#")) {
                line = line.substring(1);
            }
            String[] sa = null;
            if (line.contains(":")) {
                sa = line.split(":");
            }
            if (line.contains("=")) {
                sa = line.split("=");
            }
            ret.put(sa[0].trim(), sa[1].trim());
        }
        return ret;
    }

    private class LineWrapper
    implements Spliterator<T> {
        private Spliterator<String> lines;

        LineWrapper(Spliterator<String> lines) {
            this.lines = lines;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.lines.tryAdvance(line -> {
                try {
                    Object bean = LineIteratorReader.this.create((String)line);
                    if (bean != null) {
                        action.accept((Object)bean);
                    }
                }
                catch (ReaderException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        @Override
        public Spliterator<T> trySplit() {
            Spliterator<String> split = this.lines.trySplit();
            if (split == null) {
                return null;
            }
            return new LineWrapper(split);
        }

        @Override
        public long estimateSize() {
            return this.lines.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.lines.characteristics();
        }
    }
}

