/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.Arrays;
import java.util.Collection;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Ortholog;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;

class OrthologBaylorReader<N extends AbstractEntity>
extends LineIteratorReader<N> {
    public static final Collection<String> VARIANTS = Arrays.asList("snv", "deletion", "insertion", "indel", "substitution");

    OrthologBaylorReader() {
    }

    @Override
    public OrthologBaylorReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter(",");
        return this;
    }

    @Override
    protected N create(String line) throws ReaderException {
        try {
            String[] rec = line.split(this.getDelimiter());
            if (rec.length != 6) {
                return null;
            }
            Ortholog bean = new Ortholog(rec[2], rec[5]);
            this.parseColon(bean, rec[0], rec[3]);
            bean.setSource("BAYLOR");
            return (N)bean;
        }
        catch (ArrayIndexOutOfBoundsException ne) {
            throw new ReaderException("Cannot parse line: " + line, ne);
        }
    }

    private void parseColon(Ortholog orth, String ... values) {
        for (String value : values) {
            String[] split = value.split(":");
            if (split[0].toLowerCase().startsWith("mgi")) {
                orth.setMgi(Integer.parseInt(split[1]));
                continue;
            }
            if (!split[0].toLowerCase().startsWith("hgnc")) continue;
            orth.setHgnc(Integer.parseInt(split[1]));
        }
    }
}

