/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.geneweaver.io.reader.ArchiveReader;
import org.geneweaver.io.reader.BedReader;
import org.geneweaver.io.reader.ChiapetReader;
import org.geneweaver.io.reader.Fantom5EnsemblMapReader;
import org.geneweaver.io.reader.FastVCFReader;
import org.geneweaver.io.reader.FlexEQTLReader;
import org.geneweaver.io.reader.GTExEQTLReader;
import org.geneweaver.io.reader.GTExSampleReader;
import org.geneweaver.io.reader.GeneReader;
import org.geneweaver.io.reader.HomologGeneReader;
import org.geneweaver.io.reader.JaxEQTLReader;
import org.geneweaver.io.reader.JaxIntervalEQTLReader;
import org.geneweaver.io.reader.MapCSVReader;
import org.geneweaver.io.reader.OrthologBaylorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.RegulatoryFeatureReader;
import org.geneweaver.io.reader.StepReader;
import org.geneweaver.io.reader.StreamReader;
import org.geneweaver.io.reader.VariantReader;

public class ReaderFactory {
    private static final Map<Object, Object> classes;

    public static <R extends StreamReader<T>, T> R getReader(ReaderRequest request) throws ReaderException {
        Class<R> clazz = ReaderFactory.getClass(request);
        try {
            Constructor<R> constructor = clazz.getDeclaredConstructor(new Class[0]);
            StreamReader instance = (StreamReader)constructor.newInstance(new Object[0]);
            if (request.isInitRequired()) {
                Method init = clazz.getMethod("init", ReaderRequest.class);
                init.invoke((Object)instance, request);
            }
            return (R)instance;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ReaderException(e);
        }
    }

    private static <R extends StreamReader<T>, T> Class<R> getClass(ReaderRequest request) throws ReaderException {
        Class<R> clazz = ReaderFactory.getClassByName(request);
        if (clazz != null) {
            return clazz;
        }
        throw new ReaderException("There is no reader for " + request.name());
    }

    public static boolean isSupported(ReaderRequest request) throws ReaderException {
        Class clazz = ReaderFactory.getClassByName(request);
        return clazz != null;
    }

    private static <R extends StreamReader<T>, T> Class<R> getClassByName(ReaderRequest request) throws ReaderException {
        String name = request.name();
        Object found = null;
        for (Object key : classes.keySet()) {
            Pattern pattern;
            Matcher matcher;
            if (!(key instanceof Pattern) || !(matcher = (pattern = (Pattern)key).matcher(name)).matches()) continue;
            request.setMatcher(matcher);
            found = classes.get(key);
            break;
        }
        if (found == null) {
            for (Object key : classes.keySet()) {
                if (!(key instanceof String)) continue;
                String ext = FilenameUtils.getExtension((String)name);
                if ("gz".equals(ext)) {
                    ext = FilenameUtils.getExtension((String)name.substring(0, name.length() - 3));
                }
                if (ext == null) {
                    throw new ReaderException(name + " does not have an extension!");
                }
                ext = ext.toLowerCase();
                if (!key.toString().toLowerCase().equals(ext)) continue;
                found = classes.get(ext);
                break;
            }
        }
        if (found != null) {
            if (found instanceof Class) {
                return (Class)found;
            }
            if (found instanceof Collection) {
                if (request.getReaderHint() == null) {
                    return (Class)((Collection)found).iterator().next();
                }
                String hint = request.getReaderHint();
                for (Class clazz : (Collection)found) {
                    if (!clazz.getName().contains(hint)) continue;
                    return clazz;
                }
            }
        }
        return null;
    }

    static {
        LinkedHashMap<Object, Object> tmp = new LinkedHashMap<Object, Object>();
        tmp.put("gtf", GeneReader.class);
        tmp.put("gvf", VariantReader.class);
        tmp.put("vcf", FastVCFReader.class);
        tmp.put("bed", BedReader.class);
        tmp.put("gff", RegulatoryFeatureReader.class);
        tmp.put("step", StepReader.class);
        tmp.put("xls", ChiapetReader.class);
        tmp.put("tsv", Arrays.asList(Fantom5EnsemblMapReader.class, MapCSVReader.class));
        tmp.put("txt", MapCSVReader.class);
        tmp.put("rpt", HomologGeneReader.class);
        tmp.put(Pattern.compile("^.+\\_balyor\\.csv(\\.gz)?$"), OrthologBaylorReader.class);
        tmp.put(Pattern.compile("^.+aon-mappings\\.csv(\\.gz)?$"), OrthologBaylorReader.class);
        tmp.put("csv", Arrays.asList(JaxEQTLReader.class, MapCSVReader.class, JaxIntervalEQTLReader.class, OrthologBaylorReader.class));
        tmp.put(Pattern.compile("^(.+)_.+_eQTLs.txt(\\.gz)?$"), FlexEQTLReader.class);
        tmp.put(Pattern.compile("^.+\\.egenes\\.txt(\\.gz)?$"), GTExEQTLReader.class);
        tmp.put(Pattern.compile("^.+\\.sgenes\\.txt(\\.gz)?$"), GTExEQTLReader.class);
        tmp.put(Pattern.compile("^.+\\.signif_variant_gene_pairs\\.txt(\\.gz)?$"), GTExEQTLReader.class);
        tmp.put(Pattern.compile("^.+\\.sqtl_signifpairs\\.txt(\\.gz)?$"), GTExEQTLReader.class);
        tmp.put(Pattern.compile("^.+\\.allpairs\\.txt(\\.gz)?$"), GTExEQTLReader.class);
        tmp.put(Pattern.compile("^.+\\.sqtl_allpairs\\.txt(\\.gz)?$"), GTExEQTLReader.class);
        tmp.put(Pattern.compile("^GTEx.+Annotations.+Sample.+.txt(\\.gz)?$"), GTExSampleReader.class);
        tmp.put("tar", ArchiveReader.class);
        tmp.put("zip", ArchiveReader.class);
        classes = Collections.unmodifiableMap(tmp);
    }
}

