/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.zip.GZIPInputStream;
import org.geneweaver.domain.Entity;

public class ReaderRequest {
    private String source;
    private File file;
    @JsonIgnore
    private InputStream stream;
    private String name;
    private boolean includeAll = true;
    private String fileFilter;
    private int expectedSize;
    private boolean noInputStream = false;
    private boolean closeInputStream = true;
    @JsonIgnore
    private Class<? extends Entity> objType;
    private boolean initRequired = true;
    @JsonIgnore
    private transient Matcher matcher;
    private String delimiter = null;
    private String readerHint;

    public ReaderRequest() {
    }

    public ReaderRequest(File file) {
        this(null, file, true);
    }

    public ReaderRequest(File file, String fileFilter) {
        this(null, file, true);
        this.fileFilter = fileFilter;
    }

    public ReaderRequest(URL url) throws IOException {
        this.stream = url.openStream();
        this.name = Paths.get(url.toString(), new String[0]).getFileName().toString();
        this.file = null;
    }

    public ReaderRequest(String source, File file) {
        this(source, file, true);
    }

    public ReaderRequest(String source, File file, String delimiter) {
        this(source, file, true);
        this.setDelimiter(delimiter);
    }

    public ReaderRequest(String source, Path path) throws IOException {
        this.source = source;
        if (path.startsWith("http:/") || path.startsWith("ftp:/")) {
            String spath = path.toString().replaceAll(":/", "://");
            URL url = new URL(spath);
            this.stream = url.openStream();
            this.name = Paths.get(url.toString(), new String[0]).getFileName().toString();
            this.file = null;
        } else {
            this.file = path.toFile();
            this.name = this.file.getName();
        }
    }

    public ReaderRequest(String source, File file, boolean includeAll) {
        this.source = source;
        this.file = file;
        this.name = file.getName();
        this.includeAll = includeAll;
    }

    public ReaderRequest(InputStream stream, String name) {
        if (stream instanceof GZIPInputStream) {
            throw new IllegalArgumentException("There is no need to wrap inputstream in compressed streams!");
        }
        this.stream = stream;
        this.name = name;
    }

    public ReaderRequest(InputStream stream, String name, boolean close) {
        if (stream instanceof GZIPInputStream) {
            throw new IllegalArgumentException("There is no need to wrap inputstream in compressed streams!");
        }
        this.stream = stream;
        this.name = name;
        this.closeInputStream = close;
    }

    public ReaderRequest(String source, InputStream stream, String name) {
        if (stream instanceof GZIPInputStream) {
            throw new IllegalArgumentException("There is no need to wrap inputstream in compressed streams!");
        }
        this.source = source;
        this.stream = stream;
        this.name = name;
    }

    public ReaderRequest(String source, int expectedSize, Class<? extends Entity> objType) {
        this.source = source;
        this.expectedSize = expectedSize;
        this.objType = objType;
    }

    public ReaderRequest(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public ReaderRequest setSource(String species) {
        this.source = species;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public ReaderRequest setFile(File file) {
        this.file = file != null ? file.getAbsoluteFile() : null;
        return this;
    }

    @JsonIgnore
    public InputStream getStream() {
        return this.stream;
    }

    @JsonIgnore
    public ReaderRequest setStream(InputStream stream) {
        this.stream = stream;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ReaderRequest setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isIncludeAll() {
        return this.includeAll;
    }

    public ReaderRequest setIncludeAll(boolean includeAll) {
        this.includeAll = includeAll;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.closeInputStream, this.expectedSize, this.file, this.fileFilter, this.includeAll, this.initRequired, this.name, this.noInputStream, this.source);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReaderRequest)) {
            return false;
        }
        ReaderRequest other = (ReaderRequest)obj;
        return this.closeInputStream == other.closeInputStream && this.expectedSize == other.expectedSize && Objects.equals(this.file, other.file) && Objects.equals(this.fileFilter, other.fileFilter) && this.includeAll == other.includeAll && this.initRequired == other.initRequired && Objects.equals(this.name, other.name) && this.noInputStream == other.noInputStream && Objects.equals(this.source, other.source);
    }

    @JsonIgnore
    String name() {
        if (this.file != null) {
            return this.file.getName();
        }
        if (this.name != null) {
            return this.name;
        }
        throw new IllegalArgumentException("A reader request must have a name for the resource!");
    }

    @JsonIgnore
    String path() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return this.toString();
    }

    @JsonIgnore
    public InputStream stream() throws FileNotFoundException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.stream != null) {
            return this.stream;
        }
        return null;
    }

    @JsonIgnore
    public boolean isFileRequest() {
        return this.file != null;
    }

    @JsonIgnore
    public void close() throws IOException {
        if (!this.isCloseInputStream()) {
            return;
        }
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = null;
    }

    @JsonIgnore
    protected Class<? extends Entity> getObjType() {
        return this.objType;
    }

    @JsonIgnore
    protected void setObjType(Class<? extends Entity> objType) {
        this.objType = objType;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public ReaderRequest setExpectedSize(int expectedSize) {
        this.expectedSize = expectedSize;
        return this;
    }

    public String toString() {
        return "ReaderRequest [source=" + this.source + ", file=" + String.valueOf(this.file) + ", stream=" + String.valueOf(this.stream) + ", name=" + this.name + ", includeAll=" + this.includeAll + ", fileFilter=" + this.fileFilter + ", expectedSize=" + this.expectedSize + ", noInputStream=" + this.noInputStream + ", objType=" + String.valueOf(this.objType) + "]";
    }

    public boolean isNoInputStream() {
        return this.noInputStream;
    }

    public ReaderRequest setNoInputStream(boolean noInputStream) {
        this.noInputStream = noInputStream;
        return this;
    }

    public boolean isCloseInputStream() {
        return this.closeInputStream;
    }

    public ReaderRequest setCloseInputStream(boolean closeInputStream) {
        this.closeInputStream = closeInputStream;
        return this;
    }

    public boolean isInitRequired() {
        return this.initRequired;
    }

    public ReaderRequest setInitRequired(boolean initRequired) {
        this.initRequired = initRequired;
        return this;
    }

    public String getFileFilter() {
        return this.fileFilter;
    }

    public ReaderRequest setFileFilter(String fileFilter) {
        this.fileFilter = fileFilter;
        return this;
    }

    @JsonIgnore
    public Matcher getMatcher() {
        return this.matcher;
    }

    @JsonIgnore
    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getReaderHint() {
        return this.readerHint;
    }

    public void setReaderHint(String readerHint) {
        this.readerHint = readerHint;
    }
}

