/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.GeneticEntity;
import org.geneweaver.domain.RegulatoryFeature;
import org.geneweaver.domain.Species;
import org.geneweaver.io.connector.RegulatoryFeatureOverlapConnector;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;

class RegulatoryFeatureReader<N extends GeneticEntity>
extends LineIteratorReader<N> {
    RegulatoryFeatureReader() {
    }

    @Override
    public RegulatoryFeatureReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\t+");
        this.setAssignmentChar("=");
        this.setChunkSize(1000);
        return this;
    }

    @Override
    public <U extends Entity> Function<N, Stream<U>> getDefaultConnector() {
        RegulatoryFeatureOverlapConnector func = new RegulatoryFeatureOverlapConnector();
        return func;
    }

    @Override
    protected N create(String line) throws ReaderException {
        String[] rec = line.split(this.getDelimiter());
        RegulatoryFeature bean = new RegulatoryFeature();
        try {
            String[] dedot;
            BeanMap d = new BeanMap((Object)bean);
            this.populateStandardColumns(d, rec);
            String attrColumn = rec[8];
            Map<String, String> attributes = this.parseAttributes(attrColumn);
            d.put((Object)"featureId", (Object)attributes.get("regulatory_feature_stable_id"));
            d.put((Object)"activity", (Object)attributes.get("activity"));
            d.put((Object)"boundEnd", (Object)Integer.parseInt(attributes.get("bound_end")));
            d.put((Object)"boundStart", (Object)Integer.parseInt(attributes.get("bound_start")));
            d.put((Object)"description", (Object)attributes.get("description"));
            d.put((Object)"epigenome", (Object)attributes.get("epigenome"));
            d.put((Object)"featureType", (Object)attributes.get("feature_type"));
            String fileName = this.request.getName();
            if (fileName != null && (dedot = fileName.split("\\.")).length >= 7) {
                String species = this.getFixedSpecies(dedot[0]);
                Integer sp = Species.code(species);
                d.put((Object)"species", (Object)sp);
                d.put((Object)"assemblyVersion", (Object)dedot[1]);
                d.put((Object)"cellType", (Object)dedot[2]);
                d.put((Object)"analysisName", (Object)dedot[4]);
                d.put((Object)"resultsType", (Object)dedot[5]);
                d.put((Object)"date", (Object)dedot[6]);
            }
        }
        catch (IllegalArgumentException ne) {
            throw new ReaderException("The line " + line + " of bean type " + bean.getClass().getSimpleName() + " cannot be parsed ", ne);
        }
        return (N)bean;
    }

    private String getFixedSpecies(String species) {
        species = species.replaceAll("_", " ").trim();
        String first = String.valueOf(species.charAt(0)).toLowerCase();
        String rest = species.substring(1);
        return first + rest;
    }
}

