/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Gene;
import org.geneweaver.domain.GeneticEntity;
import org.geneweaver.domain.Transcript;
import org.geneweaver.domain.Variant;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;

public class RepeatedLineReader<T extends GeneticEntity>
extends LineIteratorReader<T> {
    private LineIteratorReader<T> reader;
    private static int geneCount;
    private static int varCount;

    public RepeatedLineReader() {
    }

    public RepeatedLineReader(ReaderRequest request) throws ReaderException {
        this.init(request);
    }

    @Override
    public RepeatedLineReader<T> init(ReaderRequest request) throws ReaderException {
        this.request = request;
        RepeatedLineReader.createIterator(request.getExpectedSize(), request.getObjType());
        this.setChunkSize(1000);
        request.setName(RepeatedLineReader.getType(request.getObjType()));
        request.setNoInputStream(true);
        this.reader = (LineIteratorReader)ReaderFactory.getReader(request);
        geneCount = 223180;
        varCount = 656;
        return this;
    }

    @Override
    protected T create(String line) throws ReaderException {
        return (T)((GeneticEntity)this.reader.create(line));
    }

    @Override
    protected String getAssignmentChar() {
        return this.reader.getAssignmentChar();
    }

    private static <T> Iterator<String> createIterator(final int size, final Class<? extends Entity> objType) {
        return new Iterator<String>(){
            int counted = 0;

            @Override
            public boolean hasNext() {
                return this.counted < size;
            }

            @Override
            public String next() {
                String line = RepeatedLineReader.nextLine(objType);
                ++this.counted;
                return line;
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.count >= this.request.getExpectedSize();
    }

    private static String getType(Class<? extends Entity> objType) {
        if (objType == Variant.class) {
            return "file.gvf";
        }
        if (objType == Gene.class || objType == Transcript.class) {
            return "file.gtf";
        }
        throw new IllegalArgumentException("Cannot repeat on type " + String.valueOf(objType));
    }

    @Override
    protected synchronized String nextLine() {
        if (this.isEmpty()) {
            return null;
        }
        ++this.count;
        return RepeatedLineReader.nextLine(this.request.getObjType());
    }

    private static <T> String nextLine(Class<? extends Entity> type) throws IllegalArgumentException {
        if (type == Gene.class) {
            return "1\tensembl\tgene\t758233\t758336\t.\t-\t.\tgene_id \"ENSG00000" + ++geneCount + "\"; gene_version \"1\"; gene_name \"RNU6-1199P\"; gene_source \"ensembl\"; gene_biotype \"snRNA\";";
        }
        if (type == Variant.class) {
            return "19\tdbSNP\tSNV\t92959\t92959\t.\t+\t.\tID=" + ++varCount + ";Variant_seq=G;ancestral_allele=A;Variant_effect=upstream_gene_variant 0 transcript ENST00000633500;evidence_values=Frequency;Dbxref=dbSNP_150:rs1025620664;Reference_seq=A";
        }
        throw new IllegalArgumentException("Cannot get example line for " + String.valueOf(type));
    }

    @Override
    public <U extends Entity> Function<T, Stream<U>> getDefaultConnector() {
        throw new IllegalArgumentException("The repeated line reader is for testing and does not have a connector type!");
    }
}

