/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.Step;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;

class StepReader
extends LineIteratorReader<Step> {
    StepReader() {
    }

    @Override
    public StepReader init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\t+");
        this.setChunkSize(1000);
        return this;
    }

    @Override
    protected Step create(String line) throws ReaderException {
        if (line.trim().equals("chr\tstart1\tend1\tchr\tstart2\tend2\tcontact\tFDR\tp-value")) {
            return null;
        }
        String[] rec = line.split(this.getDelimiter());
        Step step = new Step();
        BeanMap d = new BeanMap((Object)step);
        d.put((Object)"chr1", (Object)rec[0]);
        d.put((Object)"start1", (Object)rec[1]);
        d.put((Object)"end1", (Object)rec[2]);
        d.put((Object)"chr2", (Object)rec[3]);
        d.put((Object)"start2", (Object)rec[4]);
        d.put((Object)"end2", (Object)rec[5]);
        Map<String, Object> attributes = this.parseHeaders();
        d.put((Object)"method", attributes.get("method"));
        d.put((Object)"cellType", attributes.get("cell_type"));
        return step;
    }
}

