/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.geneweaver.io.reader.ReaderRequest;

public class StreamUtil {
    public static Iterator<String> createStream(ReaderRequest request) throws IOException {
        if (request.isFileRequest()) {
            return StreamUtil.createStream(request.getFile(), request.isCloseInputStream());
        }
        if (request.getStream() != null) {
            return StreamUtil.createStream(request.getStream(), request.name(), request.isCloseInputStream());
        }
        throw new IOException("Cannot create scanner from request " + String.valueOf(request));
    }

    public static Iterator<String> createStream(File file, boolean shouldClose) throws IOException {
        return StreamUtil.createStream(new FileInputStream(file), file.getName(), shouldClose);
    }

    public static Iterator<String> createStream(Path path, boolean shouldClose) throws IOException {
        String name = path.getFileName().toString();
        return StreamUtil.createStream(Files.newInputStream(path, new OpenOption[0]), name, shouldClose);
    }

    public static Iterator<String> createStream(URL url, boolean shouldClose) throws IOException {
        return StreamUtil.createStream(url.openStream(), FilenameUtils.getName((String)url.toString()), shouldClose);
    }

    public static Iterator<String> createStream(InputStream in, String name, boolean shouldClose) throws IOException {
        if (name.toLowerCase().endsWith(".gz")) {
            return new LineIterator(new GZIPInputStream(in), shouldClose);
        }
        return new LineIterator(in, shouldClose);
    }

    public static final InputStream unzip(InputStream in, String name) throws IOException {
        if (name.toLowerCase().endsWith(".zip")) {
            ZipInputStream zin = new ZipInputStream(in);
            zin.getNextEntry();
            return zin;
        }
        if (name.toLowerCase().toLowerCase().endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    private static class LineIterator
    implements Iterator<String>,
    Closeable {
        protected String nextLine;
        protected BufferedReader reader;
        protected boolean shouldClose;
        protected boolean shouldReadNext = true;
        protected boolean isNext;

        public LineIterator(InputStream in, boolean shouldClose) throws IOException {
            this.shouldClose = shouldClose;
            this.reader = new BufferedReader(new InputStreamReader(in));
        }

        @Override
        public boolean hasNext() {
            if (!this.shouldReadNext) {
                return this.isNext;
            }
            this.nextLine = this.line();
            this.isNext = this.nextLine != null;
            this.shouldReadNext = false;
            return this.isNext;
        }

        @Override
        public String next() {
            this.shouldReadNext = true;
            return this.nextLine;
        }

        protected String line() {
            String line = null;
            try {
                line = this.reader.readLine();
                if (line == null) {
                    this.close();
                }
                return line;
            }
            catch (IOException ne) {
                throw new IllegalArgumentException(ne);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.shouldClose) {
                this.reader.close();
            }
        }
    }
}

