/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.geneweaver.io.reader.Uberon;

class UberonService {
    private Map<String, Uberon> uberonMap;

    UberonService() {
        String path = "/UberonCLcodes.csv";
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in == null) {
            try {
                String local = "src/main/resources" + path;
                in = Files.newInputStream(Paths.get(local, new String[0]), new OpenOption[0]);
            }
            catch (IOException ignored) {
                this.uberonMap = null;
            }
        }
        this.uberonMap = this.read(in);
    }

    private Map<String, Uberon> read(InputStream in) {
        Map<String, Uberon> map;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            map = reader.lines().map(line -> line.trim()).distinct().filter(line -> !line.isBlank()).filter(line -> !line.startsWith("#")).map(line -> line.split(",")).map(segs -> {
                Uberon key = new Uberon();
                key.setTerm(segs[1]);
                key.setUberon(segs[2]);
                return new Object[]{segs[0].toLowerCase(), key};
            }).collect(Collectors.toMap(oa -> (String)oa[0], oa -> (Uberon)oa[1], (existingValue, newValue) -> existingValue));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read uberon mappings", e);
            }
        }
        reader.close();
        return map;
    }

    public String getUberonCode(String tissueName) {
        if (tissueName == null) {
            return null;
        }
        if (this.uberonMap.containsKey(tissueName = tissueName.toLowerCase())) {
            return this.uberonMap.get(tissueName).getUberon();
        }
        return this.getBestMatchByWordContents(tissueName);
    }

    private String getBestMatchByWordContents(String tissueName) {
        String[] words = tissueName.split("\\s+|_|\\.");
        List<String> originalWords = Arrays.asList(words);
        TreeMap matches = new TreeMap(Collections.reverseOrder());
        for (String tKey : this.uberonMap.keySet()) {
            String[] tWords;
            int count = 0;
            for (String word : words) {
                if (!tKey.contains(word)) continue;
                count += 3;
            }
            for (String tWord : tWords = tKey.split("\\s+|_|\\.")) {
                if (originalWords.contains(tWord)) continue;
                --count;
            }
            if (count <= 0) continue;
            matches.put(count, tKey);
        }
        if (matches.isEmpty()) {
            return null;
        }
        String key = (String)matches.firstEntry().getValue();
        if (key == null) {
            return null;
        }
        return this.uberonMap.get(key).getUberon();
    }

    public boolean isEmpty() {
        return this.uberonMap == null || this.uberonMap.isEmpty();
    }
}

