/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.GeneticEntity;
import org.geneweaver.domain.Variant;
import org.geneweaver.domain.VariantEffect;
import org.geneweaver.io.connector.VariantConnector;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;

class VariantReader<N extends GeneticEntity>
extends LineIteratorReader<N> {
    public static final Collection<String> VARIANTS = Arrays.asList("snv", "deletion", "insertion", "indel", "substitution");

    VariantReader() {
    }

    @Override
    public VariantReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\t+");
        return this;
    }

    @Override
    protected N create(String line) throws ReaderException {
        String[] rec = line.split(this.getDelimiter());
        Variant bean = new Variant();
        try {
            BeanMap d = new BeanMap((Object)bean);
            this.populate(d, rec);
            Map<String, String> attributes = this.parseAttributes(rec[8]);
            d.put((Object)"id", (Object)attributes.get("ID"));
            d.put((Object)"rsId", (Object)attributes.get("Dbxref").toString().split(":")[1]);
            d.put((Object)"dbxRef", (Object)attributes.get("Dbxref"));
            d.put((Object)"altAllele", (Object)attributes.get("Variant_seq"));
            d.put((Object)"refAllele", (Object)attributes.get("Reference_seq"));
            if (this.request.isIncludeAll()) {
                d.put((Object)"variantEffect", this.createVariantEffects(bean, attributes.get("Variant_effect")));
            }
        }
        catch (IllegalArgumentException ne) {
            throw new ReaderException("The line " + line + " of bean type " + bean.getClass().getSimpleName() + " cannot be parsed ", ne);
        }
        return (N)bean;
    }

    private Set<VariantEffect> createVariantEffects(Variant bean, String varEff) {
        if (varEff == null) {
            return null;
        }
        if (varEff.isEmpty()) {
            return null;
        }
        HashSet<VariantEffect> effects = new HashSet<VariantEffect>();
        for (String line : varEff.split(",")) {
            String[] vals = line.split(" ");
            VariantEffect effect = new VariantEffect();
            effect.setChr(bean.getChr());
            effect.setSequenceVariant(vals[0]);
            effect.setIndex(Integer.parseInt(vals[1]));
            effect.setFeatureType(vals[2]);
            effect.setFeatureId(vals[3]);
            effects.add(effect);
        }
        return effects;
    }

    @Override
    protected String getAssignmentChar() {
        return "=";
    }

    @Override
    public <U extends Entity> Function<N, Stream<U>> getDefaultConnector() {
        return new VariantConnector();
    }
}

