/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.writer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedWriter;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Stream;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.DirectSave;
import org.geneweaver.io.IPrintStream;
import org.geneweaver.io.Timer;
import org.geneweaver.io.connector.Connector;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.StreamReader;
import org.geneweaver.io.writer.Export;

public class ExportBuilder
implements AutoCloseable {
    private Path dir;
    private Iterable<Path> inputs;
    private Collection<Function<?, ?>> connectors;
    private int defaultChunkSize = 4096;
    @JsonIgnore
    private Export exporter = (builder, path) -> this.defaultExport(path, false);
    private String chunkProperty;
    private String species;
    private boolean alwaysUseDefaultConnector = false;
    private boolean parallelFiles = false;
    @JsonIgnore
    private IPrintStream out = IPrintStream.of(System.out);
    private boolean verbose = false;
    @JsonIgnore
    private Map<Class<? extends Entity>, Map<String, BufferedWriter>> writers = Collections.synchronizedMap(new HashMap());
    @JsonIgnore
    private Map<Class<? extends Entity>, Map<String, Path>> paths = Collections.synchronizedMap(new HashMap());
    private Collection<Throwable> errors = new LinkedList<Throwable>();

    public void export() throws Exception {
        try {
            if (this.isParallelFiles()) {
                this.parallelExport();
            } else {
                this.singleThreadExport();
            }
        }
        catch (Exception ne) {
            this.errors.add(ne);
            throw ne;
        }
    }

    private void singleThreadExport() throws Exception {
        for (Path input : this.inputs) {
            String message = this.exporter.export(this, input);
            this.out.println(message);
        }
    }

    private void parallelExport() throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        for (Path path : this.inputs) {
            Future<String> future = executor.submit(() -> this.exportQuietly(input));
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private String exportQuietly(Path input) {
        try {
            return this.exporter.export(this, input);
        }
        catch (Exception e) {
            this.errors.add(e);
            return null;
        }
    }

    public String status() {
        if (this.errors.isEmpty()) {
            return "Complete";
        }
        Object message = "";
        for (Throwable err : this.errors) {
            err.printStackTrace(this.out.getPrintStream());
            message = (String)message + err.getMessage() + "\n";
        }
        return message;
    }

    protected String defaultExport(Path input, boolean append) throws Exception {
        if (this.isVerbose() && this.getOut() != null) {
            this.getOut().println("Input file: " + String.valueOf(input));
        }
        StreamReader<Entity> reader = this.createReader(input);
        Collection<Function<Entity, Stream<Entity>>> conns = this.getConnnectors(reader);
        if (this.isVerbose() && this.getOut() != null) {
            this.getOut().println("Input file: " + String.valueOf(input));
            this.getOut().println("There are " + conns.size() + " connectors");
            for (Function<Entity, Stream<Entity>> c : conns) {
                this.getOut().println("Connector type: " + c.getClass().getName());
                boolean isConnector = c instanceof Connector;
                this.getOut().println("Connector instance of 'Connector' class: " + isConnector);
            }
        }
        try (DirectSave saver = new DirectSave(this.getOut(), this.isVerbose());){
            Timer timer = this.createTimer();
            Stream<Entity> stream = reader.stream();
            for (Function<Entity, Stream<Entity>> c : conns) {
                boolean isConnector = c instanceof Connector;
                if (this.isVerbose() && isConnector) {
                    Connector conn = (Connector)c;
                    stream = stream.flatMap(g -> conn.stream(g, null, this.getOut()));
                    continue;
                }
                stream = stream.flatMap(g -> (Stream)c.apply((Entity)g));
            }
            long saved = stream.map(g -> saver.save((Entity)g, this.paths, this.writers, this.dir, timer, append)).count();
            String string = "Wrote bulk file(s) for '" + String.valueOf(input.getFileName()) + "' in " + timer.getFormattedTime() + " parsed " + saved + " objects.";
            return string;
        }
    }

    private Collection<Function<Entity, Stream<Entity>>> getConnnectors(StreamReader<Entity> reader) {
        LinkedList<Function<Entity, Stream<Entity>>> conns = null;
        if (this.connectors == null || this.connectors.isEmpty()) {
            Function def = reader.getDefaultConnector();
            conns = Arrays.asList(def);
        } else {
            conns = new LinkedList();
            if (this.isAlwaysUseDefaultConnector()) {
                conns.add(reader.getDefaultConnector());
            }
            Iterator<Function<?, ?>> iterator = this.connectors.iterator();
            while (iterator.hasNext()) {
                Function<?, ?> function;
                Function<?, ?> cast = function = iterator.next();
                conns.add(cast);
            }
        }
        return conns;
    }

    public <T extends Entity> StreamReader<T> createReader(Path input) throws ReaderException {
        Object reader = ReaderFactory.getReader(new ReaderRequest(this.species, input.toFile()));
        reader.setChunkSize(this.chunkSize());
        return reader;
    }

    public Path getDir() {
        return this.dir;
    }

    public ExportBuilder setDir(Path dir) {
        this.dir = dir;
        return this;
    }

    public Iterable<Path> getInputs() {
        return this.inputs;
    }

    public ExportBuilder setInputs(Iterable<Path> inputs) {
        this.inputs = inputs;
        return this;
    }

    public ExportBuilder setInput(Path input) {
        this.inputs = Arrays.asList(input);
        return this;
    }

    public ExportBuilder addConnector(Function<?, ?> conn) {
        if (this.connectors == null) {
            this.connectors = new LinkedList();
        }
        this.connectors.add(conn);
        return this;
    }

    public int getDefaultChunkSize() {
        return this.defaultChunkSize;
    }

    public ExportBuilder setDefaultChunkSize(int defaultChunkSize) {
        this.defaultChunkSize = defaultChunkSize;
        return this;
    }

    @Override
    public void close() throws Exception {
        for (Map<String, BufferedWriter> brs : this.writers.values()) {
            for (BufferedWriter writer : brs.values()) {
                writer.close();
            }
        }
    }

    @JsonIgnore
    public Map<Class<? extends Entity>, Map<String, BufferedWriter>> getWriters() {
        return this.writers;
    }

    @JsonIgnore
    public Map<Class<? extends Entity>, Map<String, Path>> getPaths() {
        return this.paths;
    }

    @JsonIgnore
    public Export getExporter() {
        return this.exporter;
    }

    @JsonIgnore
    public ExportBuilder setExporter(Export exporter) {
        this.exporter = exporter;
        return this;
    }

    public Timer createTimer() {
        Timer timer = new Timer();
        int chunkSize = this.chunkSize();
        timer.setTimedChunkSize(chunkSize);
        return timer;
    }

    public int chunkSize() {
        String c = this.chunkProperty != null ? this.chunkProperty : String.valueOf(this.defaultChunkSize);
        return Integer.parseInt(c);
    }

    public String getChunkProperty() {
        return this.chunkProperty;
    }

    public ExportBuilder setChunkProperty(String chunkProperty) {
        this.chunkProperty = chunkProperty;
        return this;
    }

    public String getSpecies() {
        return this.species;
    }

    public ExportBuilder setSpecies(String species) {
        this.species = species;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.chunkProperty, this.defaultChunkSize, this.dir, this.inputs, this.species);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExportBuilder)) {
            return false;
        }
        ExportBuilder other = (ExportBuilder)obj;
        return Objects.equals(this.chunkProperty, other.chunkProperty) && this.defaultChunkSize == other.defaultChunkSize && Objects.equals(this.dir, other.dir) && Objects.equals(this.inputs, other.inputs) && Objects.equals(this.species, other.species);
    }

    @JsonIgnore
    public IPrintStream getOut() {
        return this.out;
    }

    @JsonIgnore
    public ExportBuilder setOut(PrintStream out) {
        this.out = IPrintStream.of(out);
        return this;
    }

    @JsonIgnore
    public ExportBuilder setOut(IPrintStream out) {
        this.out = out;
        return this;
    }

    public boolean isAlwaysUseDefaultConnector() {
        return this.alwaysUseDefaultConnector;
    }

    public ExportBuilder setAlwaysUseDefaultConnector(boolean alwaysUseDefaultConnector) {
        this.alwaysUseDefaultConnector = alwaysUseDefaultConnector;
        return this;
    }

    public boolean isParallelFiles() {
        return this.parallelFiles;
    }

    public ExportBuilder setParallelFiles(boolean parallel) {
        this.parallelFiles = parallel;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ExportBuilder setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }
}

