/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.writer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class JsonToCSVParser {
    private String delimiter = ",";

    public void convert(Path jsonFrom, Path csvTo) throws JsonParseException, IOException {
        csvTo.getParent().toFile().mkdirs();
        JsonFactory factory = new JsonFactory();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.createInput(jsonFrom)));
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.createOutput(csvTo)));){
            JsonParser parser = factory.createParser((Reader)in);
            while (parser.nextToken() != null) {
                if (!parser.isExpectedStartArrayToken()) continue;
                if ("columns".equals(parser.currentName())) {
                    this.writeLine(parser, out);
                }
                if (!"row".equals(parser.currentName())) continue;
                this.writeLine(parser, out);
            }
        }
    }

    private void writeLine(JsonParser parser, BufferedWriter out) throws IOException {
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_ARRAY) {
            out.write(parser.getValueAsString());
            token = parser.nextToken();
            if (token == JsonToken.END_ARRAY) continue;
            out.write(this.getDelimiter());
        }
        out.newLine();
    }

    private InputStream createInput(Path path) throws IOException {
        InputStream in = Files.newInputStream(path, new OpenOption[0]);
        if (path.toString().endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    private OutputStream createOutput(Path path) throws IOException {
        OutputStream out = Files.newOutputStream(path, new OpenOption[0]);
        if (path.toString().endsWith(".gz")) {
            return new GZIPOutputStream(out);
        }
        return out;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

