/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.cql;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.text.ParseException;
import org.geolatte.common.cql.CqlFilter;
import org.geolatte.common.cql.FilterExpressionBuilder;
import org.geolatte.common.cql.lexer.Lexer;
import org.geolatte.common.cql.lexer.LexerException;
import org.geolatte.common.cql.node.Start;
import org.geolatte.common.cql.parser.Parser;
import org.geolatte.common.cql.parser.ParserException;
import org.geolatte.common.expressions.Filter;

public class Cql {
    public static CqlFilter toFilter(String cqlExpression) {
        return new CqlFilter(cqlExpression);
    }

    public static Filter toStaticFilter(String cqlExpression, Class clazz) throws ParseException {
        try {
            Parser p = new Parser(new Lexer(new PushbackReader(new StringReader(cqlExpression), 1024)));
            Start tree = p.parse();
            FilterExpressionBuilder builder = new FilterExpressionBuilder();
            tree.apply(builder);
            return new Filter(builder.getExp());
        }
        catch (ParserException e) {
            ParseException parseException = new ParseException(e.getMessage(), e.getToken().getPos());
            parseException.initCause(e);
            throw parseException;
        }
        catch (LexerException e) {
            ParseException parseException = new ParseException(e.getMessage(), 0);
            parseException.initCause(e);
            throw parseException;
        }
        catch (IOException e) {
            ParseException parseException = new ParseException(e.getMessage(), 0);
            parseException.initCause(e);
            throw parseException;
        }
    }
}

