/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.cql;

import java.io.PushbackReader;
import org.geolatte.common.cql.lexer.Lexer;
import org.geolatte.common.cql.node.TLeftParen;
import org.geolatte.common.cql.node.TRightParen;
import org.geolatte.common.cql.node.TWktEmptySetLiteral;
import org.geolatte.common.cql.node.Token;

public class CqlLexer
extends Lexer {
    private Token wktToken = null;
    private int openBraces = 0;
    private String accumulatedWktText = "";

    public CqlLexer(PushbackReader in) {
        super(in);
    }

    @Override
    protected void filter() {
        if (this.state == Lexer.State.WKT) {
            if (this.wktToken == null) {
                if (this.token instanceof TWktEmptySetLiteral) {
                    this.state = Lexer.State.NORMAL;
                    return;
                }
                this.wktToken = this.token;
                this.openBraces = 0;
                this.accumulatedWktText = this.token.getText();
                this.token = null;
                return;
            }
            boolean tokenIsLeftParen = this.token instanceof TLeftParen;
            boolean tokenIsRightParen = this.token instanceof TRightParen;
            if (tokenIsLeftParen) {
                ++this.openBraces;
            } else if (tokenIsRightParen) {
                --this.openBraces;
            }
            this.accumulatedWktText = this.accumulatedWktText + this.token.getText();
            if (tokenIsRightParen && this.openBraces == 0 || this.token instanceof TWktEmptySetLiteral) {
                this.state = Lexer.State.NORMAL;
                this.wktToken.setText(this.accumulatedWktText);
                this.token = this.wktToken;
            } else {
                this.token = null;
            }
        }
    }
}

