/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.cql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.StringReader;
import org.geolatte.common.cql.CqlLexer;
import org.geolatte.common.cql.analysis.DepthFirstAdapter;
import org.geolatte.common.cql.node.Node;
import org.geolatte.common.cql.node.Start;
import org.geolatte.common.cql.node.Token;
import org.geolatte.common.cql.parser.Parser;

public class TreeDumper
extends DepthFirstAdapter {
    private int depth = 0;
    private PrintWriter out;

    public TreeDumper(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void defaultCase(Node node) {
        this.indent();
        this.out.println(((Token)node).getText());
    }

    @Override
    public void defaultIn(Node node) {
        this.indent();
        this.printNodeName(node);
        this.out.println();
        ++this.depth;
    }

    @Override
    public void defaultOut(Node node) {
        --this.depth;
        this.out.flush();
    }

    private void printNodeName(Node node) {
        String fullName = node.getClass().getName();
        String name = fullName.substring(fullName.lastIndexOf(46) + 1);
        this.out.print(name);
    }

    private void indent() {
        for (int i = 0; i < this.depth; ++i) {
            this.out.write("   ");
        }
    }

    public static void main(String[] args) throws IOException {
        String cql = "";
        if (args.length == 0) {
            System.out.println("Usage: Type an expression as command-line argument or at the break, e.g., \"(A>5)\"");
            System.out.println("Type an expression: ");
            InputStreamReader converter = new InputStreamReader(System.in);
            BufferedReader in = new BufferedReader(converter);
            cql = in.readLine();
        } else {
            cql = args[0];
        }
        Parser parser = new Parser(new CqlLexer(new PushbackReader(new StringReader(cql), 1000)));
        try {
            Start start = parser.parse();
            System.out.println("Concrete Syntax Tree:");
            start.getPExpr().apply(new TreeDumper(new PrintWriter(System.out)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

