/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.common.dataformats.json.jackson.GeometrySerializer;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;

public class GeometryCollectionSerializer
extends GeometrySerializer<GeometryCollection> {
    public GeometryCollectionSerializer(JsonMapper containingTransformation) {
        super(containingTransformation);
    }

    @Override
    protected void writeShapeSpecificSerialization(GeometryCollection value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStringField("type", "GeometryCollection");
        jgen.writeFieldName("geometries");
        jgen.writeStartArray();
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            Geometry current = value.getGeometryN(i);
            JsonSerializer ser = provider.findValueSerializer(current.getClass(), null);
            if (ser == null || !(ser instanceof GeometrySerializer)) continue;
            this.getParent().increaseDepth();
            this.getParent().moveInsideGeometryCollection();
            ser.serialize((Object)current, jgen, provider);
            this.getParent().moveOutsideGeometryCollection();
            this.getParent().decreaseDepth();
        }
        jgen.writeEndArray();
    }
}

