/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.common.dataformats.json.jackson.GeometrySerializer;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;

public class PolygonSerializer
extends GeometrySerializer<Polygon> {
    public PolygonSerializer(JsonMapper containingTransformation) {
        super(containingTransformation);
    }

    @Override
    protected void writeShapeSpecificSerialization(Polygon value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeFieldName("type");
        jgen.writeString("Polygon");
        jgen.writeArrayFieldStart("coordinates");
        JsonSerializer ser = provider.findValueSerializer(Double.class, null);
        LinearRing exterior = value.getExteriorRing();
        jgen.writeStartArray();
        for (int j = 0; j < exterior.getNumPoints(); ++j) {
            Point point = exterior.getPointN(j);
            jgen.writeStartArray();
            ser.serialize((Object)point.getX(), jgen, provider);
            ser.serialize((Object)point.getY(), jgen, provider);
            jgen.writeEndArray();
        }
        jgen.writeEndArray();
        for (int i = 0; i < value.getNumInteriorRing(); ++i) {
            LinearRing ml = value.getInteriorRingN(i);
            jgen.writeStartArray();
            for (int j = 0; j < ml.getNumPoints(); ++j) {
                Point point = ml.getPointN(j);
                jgen.writeStartArray();
                ser.serialize((Object)point.getX(), jgen, provider);
                ser.serialize((Object)point.getY(), jgen, provider);
                jgen.writeEndArray();
            }
            jgen.writeEndArray();
        }
        jgen.writeEndArray();
    }
}

