/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.to;

import org.geolatte.common.dataformats.json.to.GeoJsonTo;
import org.geolatte.common.dataformats.json.to.GeometryCollectionTo;
import org.geolatte.common.dataformats.json.to.LineStringTo;
import org.geolatte.common.dataformats.json.to.MultiLineStringTo;
import org.geolatte.common.dataformats.json.to.MultiPointTo;
import org.geolatte.common.dataformats.json.to.MultiPolygonTo;
import org.geolatte.common.dataformats.json.to.PointTo;
import org.geolatte.common.dataformats.json.to.PolygonTo;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointCollectionFactory;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.Points;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;

public class GeoJsonToAssembler {
    public GeoJsonTo toTransferObject(Geometry geometry) {
        if (geometry instanceof Point) {
            return this.toTransferObject((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toTransferObject((LineString)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.toTransferObject((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toTransferObject((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.toTransferObject((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.toTransferObject((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toTransferObject((GeometryCollection)geometry);
        }
        return null;
    }

    public PolygonTo toTransferObject(Polygon input) {
        PolygonTo result = new PolygonTo();
        result.setCrs(GeoJsonTo.createCrsTo("EPSG:" + input.getSRID()));
        double[][][] rings = new double[input.getNumInteriorRing() + 1][][];
        rings[0] = this.getPoints((Geometry)input.getExteriorRing());
        for (int i = 0; i < input.getNumInteriorRing(); ++i) {
            rings[i + 1] = this.getPoints((Geometry)input.getInteriorRingN(i));
        }
        result.setCoordinates(rings);
        return result;
    }

    public MultiLineStringTo toTransferObject(MultiLineString input) {
        MultiLineStringTo result = new MultiLineStringTo();
        double[][][] resultCoordinates = new double[input.getNumGeometries()][][];
        for (int i = 0; i < input.getNumGeometries(); ++i) {
            resultCoordinates[i] = this.getPoints((Geometry)input.getGeometryN(i));
        }
        result.setCoordinates(resultCoordinates);
        result.setCrs(GeoJsonTo.createCrsTo("EPSG:" + input.getSRID()));
        return result;
    }

    public MultiPointTo toTransferObject(MultiPoint input) {
        MultiPointTo result = new MultiPointTo();
        result.setCrs(GeoJsonTo.createCrsTo("EPSG:" + input.getSRID()));
        result.setCoordinates(this.getPoints((Geometry)input));
        return result;
    }

    public PointTo toTransferObject(Point input) {
        PointTo result = new PointTo();
        result.setCrs(GeoJsonTo.createCrsTo("EPSG:" + input.getSRID()));
        result.setCoordinates(this.getPoints((Geometry)input)[0]);
        return result;
    }

    public LineStringTo toTransferObject(LineString input) {
        LineStringTo result = new LineStringTo();
        result.setCrs(GeoJsonTo.createCrsTo("EPSG:" + input.getSRID()));
        result.setCoordinates(this.getPoints((Geometry)input));
        return result;
    }

    public MultiPolygonTo toTransferObject(MultiPolygon input) {
        MultiPolygonTo result = new MultiPolygonTo();
        double[][][][] coordinates = new double[input.getNumGeometries()][][][];
        for (int i = 0; i < input.getNumGeometries(); ++i) {
            coordinates[i] = this.toTransferObject(input.getGeometryN(i)).getCoordinates();
        }
        result.setCoordinates(coordinates);
        result.setCrs(GeoJsonTo.createCrsTo("EPSG:" + input.getSRID()));
        return result;
    }

    public GeometryCollectionTo toTransferObject(GeometryCollection input) {
        GeometryCollectionTo result = new GeometryCollectionTo();
        GeoJsonTo[] tos = new GeoJsonTo[input.getNumGeometries()];
        for (int i = 0; i < input.getNumGeometries(); ++i) {
            tos[i] = this.toTransferObject(input.getGeometryN(i));
            tos[i].setCrs(null);
        }
        result.setGeometries(tos);
        result.setCrs(GeoJsonTo.createCrsTo("EPSG:" + input.getSRID()));
        return result;
    }

    public Geometry fromTransferObject(GeoJsonTo input) throws IllegalArgumentException {
        return this.fromTransferObject(input, null);
    }

    public Geometry fromTransferObject(GeoJsonTo input, CrsId crsId) throws IllegalArgumentException {
        if (input instanceof PointTo) {
            return this.fromTransferObject((PointTo)input, crsId);
        }
        if (input instanceof MultiPointTo) {
            return this.fromTransferObject((MultiPointTo)input, crsId);
        }
        if (input instanceof LineStringTo) {
            return this.fromTransferObject((LineStringTo)input, crsId);
        }
        if (input instanceof MultiLineStringTo) {
            return this.fromTransferObject((MultiLineStringTo)input, crsId);
        }
        if (input instanceof PolygonTo) {
            return this.fromTransferObject((PolygonTo)input, crsId);
        }
        if (input instanceof MultiPolygonTo) {
            return this.fromTransferObject((MultiPolygonTo)input, crsId);
        }
        if (input instanceof GeometryCollectionTo) {
            return this.fromTransferObject((GeometryCollectionTo)input, crsId);
        }
        return null;
    }

    public Polygon fromTransferObject(PolygonTo input) {
        return this.fromTransferObject(input, null);
    }

    public Polygon fromTransferObject(PolygonTo input, CrsId crsId) {
        if (input == null) {
            return null;
        }
        crsId = this.getCrsId(input, crsId);
        GeoJsonToAssembler.isValid(input);
        return this.createPolygon(input.getCoordinates(), crsId);
    }

    public GeometryCollection fromTransferObject(GeometryCollectionTo input) {
        return this.fromTransferObject(input, null);
    }

    public GeometryCollection fromTransferObject(GeometryCollectionTo input, CrsId crsId) {
        if (input == null) {
            return null;
        }
        crsId = this.getCrsId(input, crsId);
        GeoJsonToAssembler.isValid(input);
        Geometry[] geoms = new Geometry[input.getGeometries().length];
        for (int i = 0; i < geoms.length; ++i) {
            geoms[i] = this.fromTransferObject(input.getGeometries()[i], crsId);
        }
        return new GeometryCollection(geoms);
    }

    public MultiPolygon fromTransferObject(MultiPolygonTo input) {
        return this.fromTransferObject(input, null);
    }

    public MultiPolygon fromTransferObject(MultiPolygonTo input, CrsId crsId) {
        if (input == null) {
            return null;
        }
        crsId = this.getCrsId(input, crsId);
        GeoJsonToAssembler.isValid(input);
        Polygon[] polygons = new Polygon[input.getCoordinates().length];
        for (int i = 0; i < polygons.length; ++i) {
            polygons[i] = this.createPolygon(input.getCoordinates()[i], crsId);
        }
        return new MultiPolygon(polygons);
    }

    public MultiLineString fromTransferObject(MultiLineStringTo input) {
        return this.fromTransferObject(input, null);
    }

    public MultiLineString fromTransferObject(MultiLineStringTo input, CrsId crsId) {
        if (input == null) {
            return null;
        }
        crsId = this.getCrsId(input, crsId);
        GeoJsonToAssembler.isValid(input);
        LineString[] lineStrings = new LineString[input.getCoordinates().length];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = new LineString(this.createPointSequence(input.getCoordinates()[i], crsId));
        }
        return new MultiLineString(lineStrings);
    }

    public LineString fromTransferObject(LineStringTo input) {
        return this.fromTransferObject(input, null);
    }

    public LineString fromTransferObject(LineStringTo input, CrsId crsId) {
        if (input == null) {
            return null;
        }
        crsId = this.getCrsId(input, crsId);
        GeoJsonToAssembler.isValid(input);
        return new LineString(this.createPointSequence(input.getCoordinates(), crsId));
    }

    public MultiPoint fromTransferObject(MultiPointTo input) {
        return this.fromTransferObject(input, null);
    }

    public MultiPoint fromTransferObject(MultiPointTo input, CrsId crsId) {
        if (input == null) {
            return null;
        }
        crsId = this.getCrsId(input, crsId);
        GeoJsonToAssembler.isValid(input);
        Point[] points = new Point[input.getCoordinates().length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = this.createPoint(input.getCoordinates()[i], crsId);
        }
        return new MultiPoint(points);
    }

    public Point fromTransferObject(PointTo input) {
        return this.fromTransferObject(input, null);
    }

    public Point fromTransferObject(PointTo input, CrsId crsId) {
        if (input == null) {
            return null;
        }
        crsId = this.getCrsId(input, crsId);
        GeoJsonToAssembler.isValid(input);
        return this.createPoint(input.getCoordinates(), crsId);
    }

    private Polygon createPolygon(double[][][] coordinates, CrsId crsId) {
        LinearRing[] rings = new LinearRing[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            rings[i] = new LinearRing(this.createPointSequence(coordinates[i], crsId));
        }
        return new Polygon(rings);
    }

    private PointSequence createPointSequence(double[][] coordinates, CrsId crsId) {
        if (coordinates == null) {
            return null;
        }
        if (coordinates.length == 0) {
            return PointCollectionFactory.createEmpty();
        }
        DimensionalFlag df = coordinates[0].length == 4 ? DimensionalFlag.d3DM : (coordinates[0].length == 3 ? DimensionalFlag.d3D : DimensionalFlag.d2D);
        PointSequenceBuilder psb = PointSequenceBuilders.variableSized((DimensionalFlag)df, (CrsId)crsId);
        for (double[] point : coordinates) {
            psb.add(point);
        }
        return psb.toPointSequence();
    }

    private Point createPoint(double[] input, CrsId crsIdValue) {
        if (input == null) {
            return null;
        }
        if (input.length == 2) {
            return Points.create2D((double)input[0], (double)input[1], (CrsId)crsIdValue);
        }
        if (input.length == 3) {
            return Points.create3D((double)input[0], (double)input[1], (double)input[2], (CrsId)crsIdValue);
        }
        double z = input[2];
        double m = input[3];
        if (Double.isNaN(z)) {
            return Points.create2DM((double)input[0], (double)input[1], (double)m, (CrsId)crsIdValue);
        }
        return Points.create3DM((double)input[0], (double)input[1], (double)z, (double)m, (CrsId)crsIdValue);
    }

    private double[][] getPoints(Geometry input) {
        double[][] result = new double[input.getNumPoints()][];
        for (int i = 0; i < input.getPoints().size(); ++i) {
            Point p = input.getPointN(i);
            result[i] = p.isMeasured() && p.is3D() ? new double[]{p.getX(), p.getY(), p.getZ(), p.getM()} : (p.isMeasured() ? new double[]{p.getX(), p.getY(), 0.0, p.getM()} : (p.is3D() ? new double[]{p.getX(), p.getY(), p.getZ()} : new double[]{p.getX(), p.getY()}));
        }
        return result;
    }

    protected CrsId getCrsId(GeoJsonTo to) throws IllegalArgumentException {
        if (to.getCrs() == null) {
            return CrsId.UNDEFINED;
        }
        if (to.getCrs().getType() == null || !"name".equals(to.getCrs().getType())) {
            throw new IllegalArgumentException("If the crs is specified the type must be specified. Currently, only named crses are supported.");
        }
        if (to.getCrs().getProperties() == null || to.getCrs().getProperties().getName() == null) {
            throw new IllegalArgumentException("A crs specification requires a properties value containing a name value.");
        }
        String sridString = to.getCrs().getProperties().getName();
        if (sridString.startsWith("EPSG:")) {
            Integer srid = this.parseDefault(sridString.substring(5), null);
            if (srid == null) {
                throw new IllegalArgumentException("Unable to derive SRID from crs name");
            }
            return new CrsId("EPSG", srid.intValue());
        }
        if (sridString.startsWith("urn:ogc:def:crs:EPSG:")) {
            String[] splits = sridString.split(":");
            if (splits.length != 7) {
                throw new IllegalArgumentException("Unable to derive SRID from crs name");
            }
            Integer srid = this.parseDefault(splits[6], null);
            if (srid == null) {
                throw new IllegalArgumentException("Unable to derive SRID from crs name");
            }
            return new CrsId("EPSG", srid.intValue());
        }
        throw new IllegalArgumentException("Unable to derive SRID from crs name");
    }

    private CrsId getCrsId(GeoJsonTo input, CrsId defaultCrsId) {
        CrsId crsId = defaultCrsId = defaultCrsId == null ? this.getCrsId(input) : defaultCrsId;
        if (defaultCrsId == null) {
            throw new IllegalArgumentException("Input has not CRS and no default CRS provided.");
        }
        return defaultCrsId;
    }

    protected Integer parseDefault(String input, Integer defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        Integer answer = defaultValue;
        try {
            answer = Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return answer;
    }

    protected static void isValid(GeoJsonTo to) throws IllegalArgumentException {
        if (!to.isValid()) {
            throw new IllegalArgumentException("TO is not valid.");
        }
    }
}

