/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.to;

import java.util.Arrays;
import org.geolatte.common.dataformats.json.to.CrsTo;
import org.geolatte.common.dataformats.json.to.GeoJsonTo;

public final class LineStringTo
extends GeoJsonTo {
    private double[][] coordinates;

    public LineStringTo() {
    }

    public LineStringTo(CrsTo crs, double[][] coordinates) {
        super(crs, LineStringTo.createBoundingBox(coordinates));
        this.coordinates = coordinates;
    }

    @Override
    public boolean isValid() {
        if (this.coordinates == null || this.coordinates.length < 2) {
            return false;
        }
        int length = this.coordinates[0].length;
        if (length < 2 || length > 4) {
            return false;
        }
        for (double[] points : this.coordinates) {
            if (points.length == length) continue;
            return false;
        }
        return true;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[][] coordinates) {
        this.coordinates = coordinates;
        if (this.isValid()) {
            this.setBbox(LineStringTo.createBoundingBox(coordinates));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LineStringTo lineStringTo = (LineStringTo)o;
        return Arrays.deepEquals((Object[])this.coordinates, (Object[])lineStringTo.coordinates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.coordinates != null ? Arrays.deepHashCode((Object[])this.coordinates) : 0);
        return result;
    }
}

