/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.to;

import java.util.Arrays;
import org.geolatte.common.dataformats.json.to.CrsTo;
import org.geolatte.common.dataformats.json.to.GeoJsonTo;

public final class MultiLineStringTo
extends GeoJsonTo {
    private double[][][] coordinates;

    public MultiLineStringTo() {
    }

    public MultiLineStringTo(CrsTo crs, double[][][] coordinates) {
        super(crs, MultiLineStringTo.createBoundingBox(coordinates));
        this.coordinates = coordinates;
    }

    @Override
    public boolean isValid() {
        if (this.coordinates == null || this.coordinates.length == 0) {
            return false;
        }
        for (double[][] lineString : this.coordinates) {
            if (lineString == null || lineString.length < 2) {
                return false;
            }
            int length = lineString[0].length;
            if (length < 2 || length > 4) {
                return false;
            }
            for (double[] points : lineString) {
                if (points.length == length) continue;
                return false;
            }
        }
        return true;
    }

    public double[][][] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[][][] coordinates) {
        this.coordinates = coordinates;
        if (this.isValid()) {
            this.setBbox(MultiLineStringTo.createBoundingBox(coordinates));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MultiLineStringTo multiLineStringTo = (MultiLineStringTo)o;
        return Arrays.deepEquals((Object[])this.coordinates, (Object[])multiLineStringTo.coordinates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.coordinates != null ? Arrays.deepHashCode((Object[])this.coordinates) : 0);
        return result;
    }
}

