/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.to;

import java.util.Arrays;
import org.geolatte.common.dataformats.json.to.CrsTo;
import org.geolatte.common.dataformats.json.to.GeoJsonTo;

public final class MultiPointTo
extends GeoJsonTo {
    private double[][] coordinates;

    public MultiPointTo() {
    }

    public MultiPointTo(CrsTo crsTo, double[][] coordinates) {
        super(crsTo, MultiPointTo.createBoundingBox(coordinates));
        this.coordinates = coordinates;
    }

    @Override
    public boolean isValid() {
        if (this.coordinates == null || this.coordinates.length == 0 || this.coordinates[0] == null) {
            return false;
        }
        int length = this.coordinates[0].length;
        if (length < 2 || length > 4) {
            return false;
        }
        for (double[] points : this.coordinates) {
            if (points.length == length) continue;
            return false;
        }
        return true;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[][] coordinates) {
        this.coordinates = coordinates;
        if (this.isValid()) {
            this.setBbox(MultiPointTo.createBoundingBox(coordinates));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiPointTo)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiPointTo multiPointTo = (MultiPointTo)o;
        return Arrays.deepEquals((Object[])this.coordinates, (Object[])multiPointTo.coordinates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.coordinates != null ? Arrays.deepHashCode((Object[])this.coordinates) : 0);
        return result;
    }
}

