/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.transformer;

import java.util.ArrayList;
import org.geolatte.common.transformer.GenericTransformationWrapper;
import org.geolatte.common.transformer.Transformation;
import org.geolatte.common.transformer.TransformationException;

public class TransformationChainFactory<Source, Target> {
    private TransformationChain<Source, Target> transformationChain;

    public <Intermediate> TransformationConcatenator<Intermediate, Target> first(Transformation<Source, Intermediate> firstTransformation) {
        this.transformationChain = new TransformationChain();
        ((TransformationChain)this.transformationChain).chain.add(firstTransformation);
        return new TransformationConcatenator();
    }

    private class TransformationChain<Source, Target>
    implements Transformation<Source, Target> {
        private final ArrayList<Transformation<?, ?>> chain = new ArrayList();

        private TransformationChain() {
        }

        @Override
        public Target transform(Source input) throws TransformationException {
            Object currentInput = input;
            for (Transformation<?, ?> subTransformation : this.chain) {
                currentInput = new GenericTransformationWrapper(subTransformation).transform(currentInput);
            }
            return (Target)currentInput;
        }
    }

    class TransformationConcatenator<IntermediateSource, Target> {
        TransformationConcatenator() {
        }

        public <IntermediateTarget> TransformationConcatenator<IntermediateTarget, Target> add(Transformation<IntermediateSource, IntermediateTarget> transformation) {
            TransformationChainFactory.this.transformationChain.chain.add(transformation);
            return new TransformationConcatenator<IntermediateSource, Target>();
        }

        public Transformation<Source, Target> last(Transformation<IntermediateSource, Target> transformation) {
            TransformationChainFactory.this.transformationChain.chain.add(transformation);
            return TransformationChainFactory.this.transformationChain;
        }
    }
}

