/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.transformer;

import java.util.ArrayList;
import org.geolatte.common.transformer.TransformerErrorEvent;
import org.geolatte.common.transformer.TransformerEventListener;
import org.geolatte.common.transformer.TransformerSinkErrorEvent;
import org.geolatte.common.transformer.TransformerSinkEventListener;
import org.geolatte.common.transformer.TransformerSourceErrorEvent;
import org.geolatte.common.transformer.TransformerSourceEventListener;

public abstract class TransformerChain<Source, Target> {
    private ArrayList<TransformerEventListener> transformerEventListeners = new ArrayList();
    private ArrayList<TransformerSourceEventListener> transformerSourceEventListeners = new ArrayList();
    private ArrayList<TransformerSinkEventListener> transformerSinkEventListeners = new ArrayList();

    public void addTransformerEventListener(TransformerEventListener listener) {
        if (listener != null) {
            this.transformerEventListeners.add(listener);
        }
    }

    public void removeTransformerEventListener(TransformerEventListener listener) {
        this.transformerEventListeners.remove(listener);
    }

    protected void onTransformerErrorOccurred(TransformerErrorEvent event) {
        for (TransformerEventListener listener : this.transformerEventListeners) {
            this.fireTransformerErrorEvent(listener, event);
        }
    }

    private void fireTransformerErrorEvent(TransformerEventListener listener, TransformerErrorEvent event) {
        try {
            listener.ErrorOccurred(event);
        }
        catch (RuntimeException e) {
            System.err.println("Exception thrown while trying to invoke event listener, removing bed behaved listener.");
            e.printStackTrace();
            this.removeTransformerEventListener(listener);
        }
    }

    public void addSourceEventListener(TransformerSourceEventListener listener) {
        if (listener != null) {
            this.transformerSourceEventListeners.add(listener);
        }
    }

    public void removeSourceEventListener(TransformerSourceEventListener listener) {
        this.transformerSourceEventListeners.remove(listener);
    }

    protected void onTransformerSourceErrorOccurred(TransformerSourceErrorEvent event) {
        for (TransformerSourceEventListener listener : this.transformerSourceEventListeners) {
            this.fireTransformerSourceErrorEvent(listener, event);
        }
    }

    private void fireTransformerSourceErrorEvent(TransformerSourceEventListener listener, TransformerSourceErrorEvent event) {
        try {
            listener.ErrorOccurred(event);
        }
        catch (RuntimeException e) {
            System.err.println("Exception thrown while trying to invoke event listener, removing bed behaved listener.");
            e.printStackTrace();
            this.removeSourceEventListener(listener);
        }
    }

    public void addSinkEventListener(TransformerSinkEventListener listener) {
        if (listener != null) {
            this.transformerSinkEventListeners.add(listener);
        }
    }

    public void removeSinkEventListener(TransformerSinkEventListener listener) {
        this.transformerSinkEventListeners.remove(listener);
    }

    protected void onTransformerSinkErrorOccurred(TransformerSinkErrorEvent event) {
        for (TransformerSinkEventListener listener : this.transformerSinkEventListeners) {
            this.fireTransformerSinkErrorEvent(listener, event);
        }
    }

    private void fireTransformerSinkErrorEvent(TransformerSinkEventListener listener, TransformerSinkErrorEvent event) {
        try {
            listener.ErrorOccurred(event);
        }
        catch (RuntimeException e) {
            System.err.println("Exception thrown while trying to invoke event listener, removing bad behaved listener.");
            e.printStackTrace();
            this.removeSinkEventListener(listener);
        }
    }
}

