/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.util;

public class WildcardMatch {
    private char singleCharacterWildcard = (char)63;
    private char multipleCharacterWildcard = (char)42;
    private char escapeCharacter = (char)92;
    private boolean caseSensitive = true;
    private boolean isEscaped = false;
    private int escCnt = 0;
    boolean preceededByMultipleChar = false;

    public WildcardMatch(char singleCharWildcard, char multipleCharsWildcard, char escapeChar) {
        this.setWildcardChars(singleCharWildcard, multipleCharsWildcard);
        this.setEscapeChar(escapeChar);
    }

    public WildcardMatch(char singleCharWildcard, char multipleCharsWildcard) {
        this.setWildcardChars(singleCharWildcard, multipleCharsWildcard);
    }

    public WildcardMatch() {
    }

    public void setWildcardChars(char singleChar, char multipleChars) {
        this.singleCharacterWildcard = singleChar;
        this.multipleCharacterWildcard = multipleChars;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeCharacter = escapeChar;
    }

    public char getSingleWildcardChar() {
        return this.singleCharacterWildcard;
    }

    public char getMultipleWildcardChar() {
        return this.multipleCharacterWildcard;
    }

    public char getEscapeChar() {
        return this.escapeCharacter;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean match(String s, String pattern) {
        this.preceededByMultipleChar = false;
        this.isEscaped = false;
        if (!this.caseSensitive) {
            pattern = pattern.toLowerCase();
            s = s.toLowerCase();
        }
        int offset = 0;
        do {
            String ps = this.getNextSubString(pattern);
            int len = ps.length();
            pattern = pattern.substring(len + this.escCnt);
            if (len > 0 && this.isWildcard(ps.charAt(0)) && this.escCnt == 0) {
                offset = this.getWildcardOffset(ps.charAt(0));
                if (this.isSingleWildcardChar(ps.charAt(0))) {
                    s = s.substring(1);
                }
                if (pattern.length() != 0) continue;
                return s.length() <= offset || this.preceededByMultipleChar;
            }
            int idx = s.indexOf(ps);
            if (idx < 0 || idx > offset && !this.preceededByMultipleChar) {
                return false;
            }
            s = s.substring(idx + len);
            this.preceededByMultipleChar = false;
        } while (pattern.length() != 0);
        return s.length() == 0;
    }

    private String getNextSubString(String pat) {
        this.escCnt = 0;
        if ("".equals(pat)) {
            return "";
        }
        if (this.isWildcard(pat.charAt(0))) {
            if (pat.length() > 1 && !this.isSingleWildcardChar(pat.charAt(0)) && this.isSingleWildcardChar(pat.charAt(1))) {
                this.preceededByMultipleChar = true;
            }
            return pat.substring(0, 1);
        }
        String s = "";
        for (int i = 0; i < pat.length() && !this.isWildcard(pat.charAt(i), this.isEscaped); ++i) {
            if (pat.charAt(i) == this.escapeCharacter) {
                boolean bl = this.isEscaped = !this.isEscaped;
                if (!this.isEscaped) {
                    s = s + pat.charAt(i);
                    continue;
                }
                ++this.escCnt;
                continue;
            }
            if (this.isWildcard(pat.charAt(i))) {
                this.isEscaped = false;
                s = s + pat.charAt(i);
                continue;
            }
            s = s + pat.charAt(i);
        }
        return s;
    }

    private boolean isWildcard(char c, boolean isEsc) {
        return !isEsc && this.isWildcard(c);
    }

    private boolean isSingleWildcardChar(char c) {
        return c == this.singleCharacterWildcard;
    }

    private boolean isWildcard(char c) {
        return c == this.multipleCharacterWildcard || c == this.singleCharacterWildcard;
    }

    private int getWildcardOffset(char c) {
        if (c == this.multipleCharacterWildcard) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

