/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.geolatte.geom.FeatureCollection;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.FeatureDeserializer;
import org.geolatte.geom.json.GeoJsonFeatureCollection;
import org.geolatte.geom.json.Settings;

public class FeatureCollectionDeserializer
extends JsonDeserializer<FeatureCollection> {
    private final FeatureDeserializer fDeserializer;

    public FeatureCollectionDeserializer(CoordinateReferenceSystem<?> defaultCrs, Settings settings) {
        this.fDeserializer = new FeatureDeserializer(defaultCrs, settings);
    }

    public FeatureCollection<?, ?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode root = (JsonNode)oc.readTree(jsonParser);
        JsonNode featureNds = root.get("features");
        ArrayList features = new ArrayList();
        Iterator it = featureNds.elements();
        while (it.hasNext()) {
            JsonNode fNode = (JsonNode)it.next();
            features.add(this.fDeserializer.readFeature(oc, fNode));
        }
        return new GeoJsonFeatureCollection(features);
    }
}

