/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.geolatte.geom.Feature;
import org.geolatte.geom.FeatureCollection;
import org.geolatte.geom.Position;

public class GeoJsonFeatureCollection<P extends Position, ID>
implements FeatureCollection<P, ID> {
    private final List<Feature<P, ID>> features = new ArrayList<Feature<P, ID>>();

    public GeoJsonFeatureCollection(List<Feature<P, ID>> features) {
        this.features.addAll(features);
    }

    @SafeVarargs
    GeoJsonFeatureCollection(Feature<P, ID> ... features) {
        Collections.addAll(this.features, features);
    }

    public List<Feature<P, ID>> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonFeatureCollection that = (GeoJsonFeatureCollection)o;
        return this.features.equals(that.features);
    }

    public int hashCode() {
        return Objects.hash(this.features);
    }

    public String toString() {
        return "GeoJsonFeatureCollection{features=" + this.features + '}';
    }
}

