/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geolatte.geom.Feature;
import org.geolatte.geom.FeatureCollection;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.json.CrsDeserializer;
import org.geolatte.geom.json.CrsSerializer;
import org.geolatte.geom.json.FeatureCollectionDeserializer;
import org.geolatte.geom.json.FeatureDeserializer;
import org.geolatte.geom.json.GeometryDeserializer;
import org.geolatte.geom.json.GeometrySerializer;
import org.geolatte.geom.json.Setting;
import org.geolatte.geom.json.Settings;

public class GeolatteGeomModule
extends SimpleModule {
    private final Settings settings = new Settings();
    private final Map<Class, JsonDeserializer> dezers = new HashMap<Class, JsonDeserializer>();
    private GeometrySerializer geometrySerializer = new GeometrySerializer(this.settings);
    private CrsSerializer crsSerializer;

    public GeolatteGeomModule() {
        this((CoordinateReferenceSystem)CoordinateReferenceSystems.WGS84);
    }

    public <P extends Position> GeolatteGeomModule(CoordinateReferenceSystem<P> defaultCrs) {
        super("GeolatteGeomModule", new Version(1, 8, 0, "", "org.geolatte", "geolatte-json"));
        GeometryDeserializer parser = new GeometryDeserializer(defaultCrs, this.settings);
        this.addSerializer(Geometry.class, this.geometrySerializer);
        this.crsSerializer = new CrsSerializer<P>(defaultCrs, this.settings);
        this.addSerializer(CoordinateReferenceSystem.class, this.crsSerializer);
        this.dezers.put(Geometry.class, parser);
        this.dezers.put(Point.class, parser);
        this.dezers.put(LineString.class, parser);
        this.dezers.put(Polygon.class, parser);
        this.dezers.put(MultiPoint.class, parser);
        this.dezers.put(MultiLineString.class, parser);
        this.dezers.put(MultiPolygon.class, parser);
        this.dezers.put(GeometryCollection.class, parser);
        this.dezers.put(Feature.class, new FeatureDeserializer(defaultCrs, this.settings));
        this.dezers.put(FeatureCollection.class, new FeatureCollectionDeserializer(defaultCrs, this.settings));
        this.dezers.put(CoordinateReferenceSystem.class, new CrsDeserializer(defaultCrs, this.settings));
        this.dezers.forEach((arg_0, arg_1) -> ((GeolatteGeomModule)this).addDeserializer(arg_0, arg_1));
    }

    public void set(Setting setting, boolean value) {
        this.settings.override(setting, value);
    }

    public GeometrySerializer getGeometrySerializer() {
        return this.geometrySerializer;
    }

    public Map<Class, JsonDeserializer> getGeometryDeserializers() {
        return Collections.unmodifiableMap(this.dezers);
    }

    public void copyToModule(SimpleModule other) {
        other.addSerializer((JsonSerializer)this.getGeometrySerializer());
        other.addSerializer((JsonSerializer)this.crsSerializer);
        this.getGeometryDeserializers().forEach((arg_0, arg_1) -> ((SimpleModule)other).addDeserializer(arg_0, arg_1));
    }
}

