/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Arrays;
import org.geolatte.geom.Box;
import org.geolatte.geom.Position;

public class BoxSerializer<P extends Position>
extends JsonSerializer<Box<P>> {
    public void serialize(Box<P> box, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        double[] bbox = this.concat(box.lowerLeft().toArray(null), box.upperRight().toArray(null));
        gen.writeArray(bbox, 0, bbox.length);
    }

    public boolean isEmpty(SerializerProvider provider, Box<P> box) {
        return box == null || box.isEmpty();
    }

    private double[] concat(double[] pos1, double[] pos2) {
        double[] result = Arrays.copyOf(pos1, pos1.length + pos2.length);
        System.arraycopy(pos2, 0, result, pos1.length, pos2.length);
        return result;
    }
}

