/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.Setting;
import org.geolatte.geom.json.Settings;

public class CrsDeserializer
extends JsonDeserializer<CoordinateReferenceSystem> {
    private final CoordinateReferenceSystem<?> defaultCrs;
    private final Settings settings;

    public CrsDeserializer(CoordinateReferenceSystem<?> defaultCrs, Settings settings) {
        this.defaultCrs = defaultCrs;
        this.settings = settings;
    }

    private JsonNode getRoot(JsonParser p) throws IOException, GeoJsonProcessingException {
        ObjectCodec oc = p.getCodec();
        return (JsonNode)oc.readTree(p);
    }

    public CoordinateReferenceSystem<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode root = this.getRoot(p);
        return this.resolveBaseCrs(root);
    }

    protected CoordinateReferenceSystem<?> getDefaultCrs() {
        return this.defaultCrs;
    }

    private CoordinateReferenceSystem<?> resolveBaseCrs(JsonNode root) throws GeoJsonProcessingException {
        CrsId id = this.getCrsId(root);
        return id.equals((Object)CrsId.UNDEFINED) || this.settings.isSet(Setting.IGNORE_CRS) ? this.defaultCrs : CrsRegistry.getCoordinateReferenceSystemForEPSG((int)id.getCode(), this.getDefaultCrs());
    }

    protected CrsId getCrsId(JsonNode root) throws GeoJsonProcessingException {
        JsonNode crs = root;
        if (crs == null) {
            return CrsId.UNDEFINED;
        }
        String type = crs.get("type").asText();
        if (type.equalsIgnoreCase("name")) {
            String text = crs.get("properties").get("name").asText();
            return CrsId.parse((String)text);
        }
        if (type.equalsIgnoreCase("link")) {
            String text = crs.get("properties").get("href").asText();
            String[] components = text.split("/");
            int last = components.length - 1;
            return CrsId.valueOf((String)components[last - 1], (int)Integer.decode(components[last]));
        }
        throw new GeoJsonProcessingException("Can parse only named crs elements");
    }
}

