/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.geom.Box;
import org.geolatte.geom.Feature;
import org.geolatte.geom.FeatureCollection;
import org.geolatte.geom.Position;
import org.geolatte.geom.json.Setting;
import org.geolatte.geom.json.Settings;

public class FeatureCollectionSerializer<P extends Position, ID>
extends JsonSerializer<FeatureCollection<P, ID>> {
    private final Settings settings;

    FeatureCollectionSerializer(Settings settings) {
        this.settings = settings;
    }

    public void serialize(FeatureCollection<P, ID> featureColl, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", "FeatureCollection");
        Box box = featureColl.getBbox();
        if (box != null && !box.isEmpty() && this.settings.isSet(Setting.SERIALIZE_FEATURE_COLLECTION_BBOX)) {
            gen.writeFieldName("bbox");
            gen.writeObject((Object)featureColl.getBbox());
        }
        gen.writeArrayFieldStart("features");
        for (Feature f : featureColl.getFeatures()) {
            gen.writeObject((Object)f);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

