/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.geom.Box;
import org.geolatte.geom.Feature;
import org.geolatte.geom.Position;
import org.geolatte.geom.json.Setting;
import org.geolatte.geom.json.Settings;

public class FeatureSerializer<P extends Position, ID>
extends JsonSerializer<Feature<P, ID>> {
    private final Settings settings;

    public FeatureSerializer(Settings settings) {
        this.settings = settings;
    }

    public void serialize(Feature<P, ID> feature, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        Box box;
        gen.writeStartObject();
        gen.writeStringField("type", "Feature");
        if (feature.getId() != null) {
            gen.writeFieldName("id");
            gen.writeObject(feature.getId());
        }
        if ((box = feature.getBbox()) != null && !box.isEmpty() && this.settings.isSet(Setting.SERIALIZE_FEATURE_BBOX)) {
            gen.writeFieldName("bbox");
            gen.writeObject((Object)box);
        }
        gen.writeFieldName("geometry");
        gen.writeObject((Object)feature.getGeometry());
        gen.writeFieldName("properties");
        gen.writeObject((Object)feature.getProperties());
        gen.writeEndObject();
    }
}

