/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.geolatte.geom.Box;
import org.geolatte.geom.Feature;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;

public class GeoJsonFeature<P extends Position, ID>
implements Feature<P, ID> {
    private final Geometry<P> geometry;
    private final ID id;
    private final Map<String, Object> properties;

    public GeoJsonFeature(Geometry<P> geometry, ID id, Map<String, Object> properties) {
        this.geometry = geometry;
        this.id = id;
        this.properties = properties;
    }

    public Geometry<P> getGeometry() {
        return this.geometry;
    }

    public ID getId() {
        return this.id;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Box<P> getBbox() {
        return this.geometry != null ? this.geometry.getBoundingBox() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonFeature that = (GeoJsonFeature)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "GeoJsonFeature{geometry=" + this.geometry + ", id=" + this.id + ", properties=" + this.properties + '}';
    }
}

