/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.codec.sqlserver.AbstractDecoder;
import org.geolatte.geom.codec.sqlserver.Decoders;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

abstract class AbstractGeometryCollectionDecoder<T extends GeometryCollection>
extends AbstractDecoder<T> {
    AbstractGeometryCollectionDecoder() {
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.GEOMETRYCOLLECTION;
    }

    @Override
    protected T createNullGeometry() {
        return this.createGeometry((List<Geometry>)null, false);
    }

    @Override
    protected T createGeometry(SqlServerGeometry nativeGeom) {
        return (T)this.createGeometry(nativeGeom, 0);
    }

    @Override
    protected T createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        int startChildIdx = shapeIndex + 1;
        ArrayList<Geometry> geometries = new ArrayList<Geometry>(nativeGeom.getNumShapes());
        for (int childIdx = startChildIdx; childIdx < nativeGeom.getNumShapes(); ++childIdx) {
            if (!nativeGeom.isParentShapeOf(shapeIndex, childIdx)) continue;
            AbstractDecoder decoder = (AbstractDecoder)Decoders.decoderFor(nativeGeom.getOpenGisTypeOfShape(childIdx));
            Object geometry = decoder.createGeometry(nativeGeom, childIdx);
            geometries.add((Geometry)geometry);
        }
        return this.createGeometry(geometries, nativeGeom.hasMValues());
    }

    protected abstract T createGeometry(List<Geometry> var1, boolean var2);
}

