/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.CoordinateComponent;

public enum DimensionalFlag {
    d2D(2, -1, -1),
    d3D(3, 2, -1),
    d2DM(3, -1, 2),
    d3DM(4, 2, 3);

    private final int dimension;
    public final int X = 0;
    public final int Y = 1;
    public final int Z;
    public final int M;

    private DimensionalFlag(int dimension, int zComponent, int mComponent) {
        this.dimension = dimension;
        this.Z = zComponent;
        this.M = mComponent;
    }

    public static DimensionalFlag valueOf(boolean is3D, boolean isMeasured) {
        if (isMeasured) {
            return is3D ? d3DM : d2DM;
        }
        return is3D ? d3D : d2D;
    }

    public int getCoordinateDimension() {
        return this.dimension;
    }

    public boolean is3D() {
        return this == d3D || this == d3DM;
    }

    public boolean isMeasured() {
        return this == d2DM || this == d3DM;
    }

    public int index(CoordinateComponent component) {
        switch (component) {
            case X: {
                return 0;
            }
            case Y: {
                return 1;
            }
            case Z: {
                return this.Z;
            }
            case M: {
                return this.M;
            }
        }
        return -1;
    }
}

