/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.codec.AbstractWktDecoder;
import org.geolatte.geom.codec.CrsWktTokenizer;
import org.geolatte.geom.codec.CrsWktVariant;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CoordinateSystemAxisDirection;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.Datum;
import org.geolatte.geom.crs.Ellipsoid;
import org.geolatte.geom.crs.GeocentricCoordinateReferenceSystem;
import org.geolatte.geom.crs.GeographicCoordinateReferenceSystem;
import org.geolatte.geom.crs.PrimeMeridian;
import org.geolatte.geom.crs.ProjectedCoordinateReferenceSystem;
import org.geolatte.geom.crs.Projection;
import org.geolatte.geom.crs.Unit;

public class CrsWktDecoder
extends AbstractWktDecoder<CoordinateReferenceSystem> {
    private static final CrsWktVariant CRS_TOKENS = new CrsWktVariant();

    public CrsWktDecoder() {
        super(CRS_TOKENS);
    }

    public CoordinateReferenceSystem decode(String wkt) {
        this.setTokenizer(new CrsWktTokenizer(wkt, this.getWktVariant()));
        this.nextToken();
        return this.decode();
    }

    private CoordinateReferenceSystem decode() {
        if (this.currentToken == CrsWktVariant.PROJCS) {
            return this.decodeProjectedCrs();
        }
        if (this.currentToken == CrsWktVariant.GEOGCS) {
            return this.decodeGeographicCrs();
        }
        if (this.currentToken == CrsWktVariant.GEOCCS) {
            return this.decodeGeocentricCrs();
        }
        throw new WktDecodeException("Expected Wkt Token PROJCS, GEOGCS or GEOCCS");
    }

    private CoordinateReferenceSystem decodeGeocentricCrs() {
        throw new UnsupportedConversionException("Currently not implemented");
    }

    private GeographicCoordinateReferenceSystem decodeGeographicCrs() {
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        Datum datum = this.decodeDatum();
        this.matchesElementSeparator();
        PrimeMeridian primem = this.decodePrimem();
        this.matchesElementSeparator();
        Unit unit = this.decodeUnit(Unit.Type.ANGULAR);
        CoordinateSystemAxis[] twinAxes = this.decodeOptionalTwinAxis(unit, GeographicCoordinateReferenceSystem.class);
        CrsId cr = this.decodeOptionalAuthority();
        this.matchesCloseList();
        GeographicCoordinateReferenceSystem system = new GeographicCoordinateReferenceSystem(cr, crsName, twinAxes);
        system.setDatum(datum);
        system.setPrimeMeridian(primem);
        return system;
    }

    private ProjectedCoordinateReferenceSystem decodeProjectedCrs() {
        List<CrsParameter> parameters;
        Projection projection;
        Unit unit;
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        GeographicCoordinateReferenceSystem geogcs = this.decodeGeographicCrs();
        this.matchesElementSeparator();
        if (this.currentToken == CrsWktVariant.UNIT) {
            unit = this.decodeUnit(Unit.Type.LINEAR);
            projection = this.decodeProjection();
            parameters = this.decodeOptionalParameters();
        } else {
            projection = this.decodeProjection();
            parameters = this.decodeOptionalParameters();
            unit = this.decodeUnit(Unit.Type.LINEAR);
        }
        CrsId crsId = this.decodeOptionalAuthority();
        CoordinateSystemAxis[] twinAxes = this.decodeOptionalTwinAxis(unit, ProjectedCoordinateReferenceSystem.class);
        return new ProjectedCoordinateReferenceSystem(crsId, crsName, geogcs, projection, parameters, twinAxes);
    }

    private List<CrsParameter> decodeOptionalParameters() {
        ArrayList<CrsParameter> parameters = new ArrayList<CrsParameter>();
        CrsParameter parameter = this.decodeOptionalParameter();
        while (parameter != null) {
            parameters.add(parameter);
            parameter = this.decodeOptionalParameter();
        }
        return parameters;
    }

    private CrsParameter decodeOptionalParameter() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.PARAMETER) {
            return null;
        }
        this.nextToken();
        String name = this.decodeName();
        this.matchesElementSeparator();
        double value = this.decodeNumber();
        this.matchesCloseList();
        return new CrsParameter(name, value);
    }

    private Projection decodeProjection() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.PROJECTION) {
            throw new WktDecodeException("Expected PROJECTION keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        CrsId crsId = this.decodeOptionalAuthority();
        this.matchesCloseList();
        return new Projection(crsId, name);
    }

    private <T extends CoordinateReferenceSystem> CoordinateSystemAxis[] decodeOptionalTwinAxis(Unit unit, Class<T> crsClass) {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.AXIS) {
            return this.defaultCRS(unit, crsClass);
        }
        CoordinateSystemAxis[] twinAxes = new CoordinateSystemAxis[2];
        twinAxes[0] = this.decodeAxis(unit);
        this.matchesElementSeparator();
        twinAxes[1] = this.decodeAxis(unit);
        return twinAxes;
    }

    private <T extends CoordinateReferenceSystem> CoordinateSystemAxis[] defaultCRS(Unit unit, Class<T> crsClass) {
        if (GeographicCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new CoordinateSystemAxis("Lon", CoordinateSystemAxisDirection.EAST, unit), new CoordinateSystemAxis("Lat", CoordinateSystemAxisDirection.NORTH, unit)};
        }
        if (ProjectedCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new CoordinateSystemAxis("X", CoordinateSystemAxisDirection.EAST, unit), new CoordinateSystemAxis("Y", CoordinateSystemAxisDirection.NORTH, unit)};
        }
        if (GeocentricCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new CoordinateSystemAxis("X", CoordinateSystemAxisDirection.GeocentricX, unit), new CoordinateSystemAxis("Y", CoordinateSystemAxisDirection.GeocentricY, unit), new CoordinateSystemAxis("Z", CoordinateSystemAxisDirection.GeocentricZ, unit)};
        }
        throw new IllegalStateException("Can't create default for CrsRegistry of type " + crsClass.getCanonicalName());
    }

    private CoordinateSystemAxis decodeAxis(Unit unit) {
        if (this.currentToken != CrsWktVariant.AXIS) {
            throw new WktDecodeException("Expected AXIS keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        CoordinateSystemAxisDirection direction = CoordinateSystemAxisDirection.valueOf(this.currentToken.toString());
        this.nextToken();
        this.matchesCloseList();
        return new CoordinateSystemAxis(name, direction, unit);
    }

    private Unit decodeUnit(Unit.Type type) {
        if (this.currentToken != CrsWktVariant.UNIT) {
            throw new WktDecodeException("Expected UNIT keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        double cf = this.decodeNumber();
        this.matchesElementSeparator();
        CrsId crsId = this.decodeOptionalAuthority();
        this.matchesCloseList();
        return new Unit(crsId, name, type, cf);
    }

    private PrimeMeridian decodePrimem() {
        if (this.currentToken != CrsWktVariant.PRIMEM) {
            throw new WktDecodeException("Expected PRIMEM keyword, received " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        double longitude = this.decodeNumber();
        CrsId crsId = this.decodeOptionalAuthority();
        this.matchesCloseList();
        return new PrimeMeridian(crsId, name, longitude);
    }

    private Datum decodeDatum() {
        if (this.currentToken != CrsWktVariant.DATUM) {
            throw new WktDecodeException("Expected DATUM token.");
        }
        String datumName = this.decodeName();
        this.matchesElementSeparator();
        Ellipsoid ellipsoid = this.decodeSpheroid();
        double[] toWGS84 = this.decodeOptionalToWGS84();
        CrsId crsId = this.decodeOptionalAuthority();
        this.matchesCloseList();
        return new Datum(crsId, ellipsoid, datumName, toWGS84);
    }

    private double[] decodeOptionalToWGS84() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.TOWGS84) {
            return new double[0];
        }
        this.nextToken();
        double[] toWGS = new double[7];
        this.matchesOpenList();
        for (int i = 0; i < 7; ++i) {
            toWGS[i] = this.decodeNumber();
            this.matchesElementSeparator();
        }
        this.matchesCloseList();
        return toWGS;
    }

    private Ellipsoid decodeSpheroid() {
        if (this.currentToken != CrsWktVariant.SPHEROID) {
            throw new WktDecodeException("Expected SPHEROID keyword, but received " + this.currentToken.toString());
        }
        String ellipsoidName = this.decodeName();
        this.matchesElementSeparator();
        double semiMajorAxis = this.decodeNumber();
        this.matchesElementSeparator();
        double inverseFlattening = this.decodeNumber();
        CrsId crsId = this.decodeOptionalAuthority();
        this.matchesCloseList();
        return new Ellipsoid(crsId, ellipsoidName, semiMajorAxis, inverseFlattening);
    }

    private CrsId decodeOptionalAuthority() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.AUTHORITY) {
            return CrsId.UNDEFINED;
        }
        this.nextToken();
        this.matchesOpenList();
        String authority = this.decodeText();
        this.matchesElementSeparator();
        String value = this.decodeText();
        this.matchesCloseList();
        if (authority.equals("EPSG")) {
            try {
                return new CrsId("EPSG", Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new WktDecodeException("Expected EPSG integer code, received " + value);
            }
        }
        return CrsId.UNDEFINED;
    }

    private String decodeName() {
        this.nextToken();
        this.matchesOpenList();
        return this.decodeText();
    }
}

