/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LineString;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.codec.sqlserver.AbstractEncoder;
import org.geolatte.geom.codec.sqlserver.CountingPointSequenceBuilder;
import org.geolatte.geom.codec.sqlserver.Figure;
import org.geolatte.geom.codec.sqlserver.FigureAttribute;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.Shape;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

class LineStringEncoder
extends AbstractEncoder<LineString> {
    LineStringEncoder() {
    }

    @Override
    protected void encode(Geometry geom, int parentShapeIndex, CountingPointSequenceBuilder coordinates, List<Figure> figures, List<Shape> shapes) {
        if (!(geom instanceof LineString)) {
            throw new IllegalArgumentException("Require LineString geometry");
        }
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentShapeIndex, -1, OpenGisType.LINESTRING));
            return;
        }
        int figureOffset = figures.size();
        int pointOffset = coordinates.getNumAdded();
        for (Point point : (PointSequence)geom.getPoints()) {
            coordinates.add(point);
        }
        figures.add(new Figure(FigureAttribute.Stroke, pointOffset));
        shapes.add(new Shape(parentShapeIndex, figureOffset, OpenGisType.LINESTRING));
    }

    @Override
    protected void encodePoints(SqlServerGeometry nativeGeom, PointCollection coordinates) {
        super.encodePoints(nativeGeom, coordinates);
        if (coordinates.size() == 2) {
            nativeGeom.setIsSingleLineSegment();
        }
    }

    @Override
    public boolean accepts(Geometry geom) {
        return geom instanceof LineString;
    }
}

