/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Point;
import org.geolatte.geom.codec.sqlserver.AbstractEncoder;
import org.geolatte.geom.codec.sqlserver.CountingPointSequenceBuilder;
import org.geolatte.geom.codec.sqlserver.Figure;
import org.geolatte.geom.codec.sqlserver.FigureAttribute;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.Shape;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

class PointEncoder
extends AbstractEncoder<Point> {
    PointEncoder() {
    }

    @Override
    public SqlServerGeometry encode(Point geom) {
        SqlServerGeometry sqlServerGeom = new SqlServerGeometry();
        int srid = geom.getSRID();
        sqlServerGeom.setSrid(srid < 0 ? 0 : srid);
        sqlServerGeom.setIsValid();
        if (geom.isEmpty()) {
            sqlServerGeom.setNumberOfPoints(0);
            sqlServerGeom.setNumberOfFigures(0);
            sqlServerGeom.setNumberOfShapes(1);
            sqlServerGeom.setShape(0, new Shape(-1, -1, OpenGisType.POINT));
            return sqlServerGeom;
        }
        sqlServerGeom.setIsSinglePoint();
        sqlServerGeom.setNumberOfPoints(1);
        if (geom.is3D()) {
            sqlServerGeom.setHasZValues();
            sqlServerGeom.allocateZValueArray();
        }
        if (geom.isMeasured()) {
            sqlServerGeom.setHasMValues();
            sqlServerGeom.allocateMValueArray();
        }
        sqlServerGeom.setCoordinate(0, geom.getPoints());
        return sqlServerGeom;
    }

    @Override
    protected void encode(Geometry geom, int parentIdx, CountingPointSequenceBuilder coordinates, List<Figure> figures, List<Shape> shapes) {
        if (!(geom instanceof Point)) {
            throw new IllegalArgumentException("Require Point geometry");
        }
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentIdx, -1, OpenGisType.POINT));
            return;
        }
        int pntOffset = coordinates.getNumAdded();
        int figureOffset = figures.size();
        coordinates.add(geom.getPointN(0));
        Figure figure = new Figure(FigureAttribute.Stroke, pntOffset);
        figures.add(figure);
        Shape shape = new Shape(parentIdx, figureOffset, OpenGisType.POINT);
        shapes.add(shape);
    }

    @Override
    public boolean accepts(Geometry geom) {
        return geom instanceof Point;
    }
}

