/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Position;
import org.geolatte.geom.Positions;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class Envelope<P extends Position> {
    private final CoordinateReferenceSystem<P> crs;
    private final P lowerLeft;
    private final P upperRight;

    public Envelope(CoordinateReferenceSystem<P> crs) {
        this.crs = crs;
        this.lowerLeft = Positions.mkPosition(crs, new double[0]);
        this.upperRight = this.lowerLeft;
    }

    public Envelope(P lowerLeft, P upperRight, CoordinateReferenceSystem<P> crs) {
        if (lowerLeft == null || upperRight == null) {
            throw new IllegalArgumentException("Envelope requires non-null Positions");
        }
        this.lowerLeft = lowerLeft;
        this.upperRight = upperRight;
        this.crs = crs;
    }

    public Envelope(double minC1, double minC2, double maxC1, double maxC2, CoordinateReferenceSystem<P> crs) {
        double h;
        if (crs == null) {
            throw new IllegalArgumentException("Null CRS argument not allowed");
        }
        if (minC1 > maxC1) {
            h = maxC1;
            maxC1 = minC1;
            minC1 = h;
        }
        if (minC2 > maxC2) {
            h = maxC2;
            maxC2 = minC2;
            minC2 = h;
        }
        this.crs = crs;
        this.lowerLeft = Positions.mkPosition(crs, minC1, minC2);
        this.upperRight = Positions.mkPosition(crs, maxC1, maxC2);
    }

    public CoordinateReferenceSystem<P> getCoordinateReferenceSystem() {
        return this.crs;
    }

    public P lowerLeft() {
        return this.lowerLeft;
    }

    public P upperRight() {
        return this.upperRight;
    }

    public P upperLeft() {
        return Positions.mkPosition(this.getCoordinateReferenceSystem(), ((Position)this.lowerLeft).getCoordinate(0), ((Position)this.upperRight).getCoordinate(1));
    }

    public P lowerRight() {
        return Positions.mkPosition(this.getCoordinateReferenceSystem(), ((Position)this.upperRight).getCoordinate(0), ((Position)this.lowerLeft).getCoordinate(1));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getCoordinateReferenceSystem().getCrsId().toString());
        builder.append("LL: ").append(((Position)this.lowerLeft).toString()).append(" - UR: ").append(((Position)this.upperRight).toString());
        return builder.toString();
    }

    protected double getMinC0() {
        return ((Position)this.lowerLeft).getCoordinate(0);
    }

    protected double getMinC1() {
        return ((Position)this.lowerLeft).getCoordinate(1);
    }

    protected double getMaxC0() {
        return ((Position)this.upperRight).getCoordinate(0);
    }

    protected double getMaxC1() {
        return ((Position)this.upperRight).getCoordinate(1);
    }

    public Envelope<P> union(Envelope<P> other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (!this.getCoordinateReferenceSystem().equals(other.getCoordinateReferenceSystem())) {
            throw new IllegalArgumentException("Envelopes have different CRS.");
        }
        double minC0 = Math.min(this.getMinC0(), other.getMinC0());
        double minC1 = Math.min(this.getMinC1(), other.getMinC1());
        double maxC0 = Math.max(this.getMaxC0(), other.getMaxC0());
        double maxC1 = Math.max(this.getMaxC1(), other.getMaxC1());
        return new Envelope<P>(minC0, minC1, maxC0, maxC1, this.getCoordinateReferenceSystem());
    }

    public Envelope intersect(Envelope other) {
        if (this.isEmpty() || other.isEmpty()) {
            return this.mkEmpty();
        }
        if (!this.getCoordinateReferenceSystem().equals(other.getCoordinateReferenceSystem())) {
            throw new IllegalArgumentException("Envelopes have different CRS.");
        }
        double minC0 = Math.max(this.getMinC0(), other.getMinC0());
        double minC1 = Math.max(this.getMinC1(), other.getMinC1());
        double maxC0 = Math.min(this.getMaxC0(), other.getMaxC0());
        double maxC1 = Math.min(this.getMaxC1(), other.getMaxC1());
        if (minC0 > maxC0 || minC1 > maxC1) {
            return this.mkEmpty();
        }
        return new Envelope<P>(minC0, minC1, maxC0, maxC1, this.getCoordinateReferenceSystem());
    }

    private Envelope<P> mkEmpty() {
        return new Envelope<P>(Double.NaN, Double.NaN, Double.NaN, Double.NaN, this.getCoordinateReferenceSystem());
    }

    public boolean isEmpty() {
        return Double.isNaN(this.getMinC0()) || Double.isNaN(this.getMinC1()) || Double.isNaN(this.getMaxC0()) || Double.isNaN(this.getMaxC1());
    }

    public boolean within(Envelope other) {
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        if (!this.getCoordinateReferenceSystem().equals(other.getCoordinateReferenceSystem())) {
            throw new IllegalArgumentException("Envelopes have different CRS.");
        }
        return other.getMinC0() <= this.getMinC0() && other.getMaxC0() >= this.getMaxC0() && other.getMinC1() <= this.getMinC1() && other.getMaxC1() >= this.getMaxC1();
    }

    public double extentAlongDimension(int i) {
        if (i < 0 || i > 2) {
            throw new IndexOutOfBoundsException("Index negative or larger than defined extent dimension");
        }
        return ((Position)this.upperRight).getCoordinate(i) - ((Position)this.lowerLeft).getCoordinate(i);
    }

    public boolean contains(Envelope other) {
        return other.within(this);
    }

    public boolean contains(P p) {
        if (!p.getClass().equals(this.getCoordinateReferenceSystem().getPositionClass())) {
            throw new IllegalArgumentException("Position and envelope of different types");
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.getMinC0() <= ((Position)p).getCoordinate(0) && this.getMaxC0() >= ((Position)p).getCoordinate(0) && this.getMinC1() <= ((Position)p).getCoordinate(1) && this.getMaxC1() >= ((Position)p).getCoordinate(1);
    }

    public boolean intersects(Envelope other) {
        return !(this.isEmpty() || other.isEmpty() || this.getMaxC0() < other.getMinC0() || this.getMinC0() > other.getMaxC0() || this.getMaxC1() < other.getMinC1() || this.getMinC1() > other.getMaxC1());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Envelope envelope = (Envelope)o;
        if (this.crs != null ? !this.crs.equals(envelope.crs) : envelope.crs != null) {
            return false;
        }
        if (this.isEmpty() && envelope.isEmpty()) {
            return true;
        }
        if (this.lowerLeft != null ? !((Position)this.lowerLeft).equals(envelope.lowerLeft) : envelope.lowerLeft != null) {
            return false;
        }
        return !(this.upperRight != null ? !((Position)this.upperRight).equals(envelope.upperRight) : envelope.upperRight != null);
    }

    public int hashCode() {
        int result = this.crs != null ? this.crs.hashCode() : 0;
        result = 31 * result + (this.lowerLeft != null ? ((Position)this.lowerLeft).hashCode() : 0);
        result = 31 * result + (this.upperRight != null ? ((Position)this.upperRight).hashCode() : 0);
        return result;
    }
}

