/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.C2D;
import org.geolatte.geom.C2DM;
import org.geolatte.geom.C3D;
import org.geolatte.geom.C3DM;
import org.geolatte.geom.G2D;
import org.geolatte.geom.G2DM;
import org.geolatte.geom.G3D;
import org.geolatte.geom.G3DM;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionFactory;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.PositionVisitor;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class Positions {
    public static List<PositionFactory<?>> registeredFactories = Arrays.asList(new CanMakeG2D(), new CanMakeG2DM(), new CanMakeG3D(), new CanMakeG3DM(), new CanMakeP2D(), new CanMakeP2DM(), new CanMakeP3D(), new CanMakeP3DM());

    public static <P extends Position> P mkPosition(Class<P> pClass, double ... coordinates) {
        PositionFactory<P> factory = Positions.getFactoryFor(pClass);
        return factory.mkPosition(coordinates);
    }

    public static <P extends Position> P mkPosition(CoordinateReferenceSystem<P> crs, double ... coordinates) {
        return Positions.mkPosition(crs.getPositionClass(), coordinates);
    }

    public static <P extends Position> PositionFactory<P> getFactoryFor(Class<P> pClass) {
        for (PositionFactory<?> pFact : registeredFactories) {
            if (!pFact.forClass().equals(pClass)) continue;
            return pFact;
        }
        throw new UnsupportedOperationException(String.format("Position type %s unsupported", pClass.getSimpleName()));
    }

    public static <Q extends Position, P extends Position> PositionSequence<P> copy(PositionSequence<Q> source, Class<P> targetPosClass) {
        PositionFactory<P> factory = Positions.getFactoryFor(targetPosClass);
        final PositionSequenceBuilder<P> builder = PositionSequenceBuilders.fixedSized(source.size(), targetPosClass);
        if (source.isEmpty()) {
            return builder.toPositionSequence();
        }
        final double[] coords = new double[Math.max(source.getCoordinateDimension(), factory.getCoordinateDimension())];
        Arrays.fill(coords, Double.NaN);
        PositionVisitor visitor = new PositionVisitor<Q>(){

            @Override
            public void visit(Q position) {
                ((Position)position).toArray(coords);
                builder.add(coords);
            }
        };
        source.accept(visitor);
        return builder.toPositionSequence();
    }

    public static class CanMakeG3DM
    implements PositionFactory<G3DM> {
        @Override
        public Class<G3DM> forClass() {
            return G3DM.class;
        }

        @Override
        public int getCoordinateDimension() {
            return 4;
        }

        @Override
        public G3DM mkPosition(double ... coordinates) {
            return coordinates.length == 0 ? new G3DM() : new G3DM(coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
        }

        @Override
        public boolean hasZComponent() {
            return true;
        }

        @Override
        public boolean hasMComponent() {
            return true;
        }

        @Override
        public int getMComponentIndex() {
            return 3;
        }
    }

    public static class CanMakeG3D
    implements PositionFactory<G3D> {
        @Override
        public Class<G3D> forClass() {
            return G3D.class;
        }

        @Override
        public int getCoordinateDimension() {
            return 3;
        }

        @Override
        public G3D mkPosition(double ... coordinates) {
            return coordinates.length == 0 ? new G3D() : new G3D(coordinates[0], coordinates[1], coordinates[2]);
        }

        @Override
        public boolean hasZComponent() {
            return true;
        }

        @Override
        public boolean hasMComponent() {
            return false;
        }

        @Override
        public int getMComponentIndex() {
            return -1;
        }
    }

    public static class CanMakeG2DM
    implements PositionFactory<G2DM> {
        @Override
        public Class<G2DM> forClass() {
            return G2DM.class;
        }

        @Override
        public int getCoordinateDimension() {
            return 3;
        }

        @Override
        public G2DM mkPosition(double ... coordinates) {
            return coordinates.length == 0 ? new G2DM() : new G2DM(coordinates[0], coordinates[1], coordinates[2]);
        }

        @Override
        public boolean hasZComponent() {
            return false;
        }

        @Override
        public boolean hasMComponent() {
            return true;
        }

        @Override
        public int getMComponentIndex() {
            return 2;
        }
    }

    public static class CanMakeG2D
    implements PositionFactory<G2D> {
        @Override
        public Class<G2D> forClass() {
            return G2D.class;
        }

        @Override
        public int getCoordinateDimension() {
            return 2;
        }

        @Override
        public G2D mkPosition(double ... coordinates) {
            return coordinates.length == 0 ? new G2D() : new G2D(coordinates[0], coordinates[1]);
        }

        @Override
        public boolean hasZComponent() {
            return false;
        }

        @Override
        public boolean hasMComponent() {
            return false;
        }

        @Override
        public int getMComponentIndex() {
            return -1;
        }
    }

    public static class CanMakeP3DM
    implements PositionFactory<C3DM> {
        @Override
        public Class<C3DM> forClass() {
            return C3DM.class;
        }

        @Override
        public int getCoordinateDimension() {
            return 4;
        }

        @Override
        public C3DM mkPosition(double ... coordinates) {
            return coordinates.length == 0 ? new C3DM() : new C3DM(coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
        }

        @Override
        public boolean hasZComponent() {
            return true;
        }

        @Override
        public boolean hasMComponent() {
            return true;
        }

        @Override
        public int getMComponentIndex() {
            return 3;
        }
    }

    public static class CanMakeP3D
    implements PositionFactory<C3D> {
        @Override
        public Class<C3D> forClass() {
            return C3D.class;
        }

        @Override
        public int getCoordinateDimension() {
            return 3;
        }

        @Override
        public C3D mkPosition(double ... coordinates) {
            return coordinates.length == 0 ? new C3D() : new C3D(coordinates[0], coordinates[1], coordinates.length > 2 ? coordinates[2] : 0.0);
        }

        @Override
        public boolean hasZComponent() {
            return true;
        }

        @Override
        public boolean hasMComponent() {
            return false;
        }

        @Override
        public int getMComponentIndex() {
            return -1;
        }
    }

    public static class CanMakeP2DM
    implements PositionFactory<C2DM> {
        @Override
        public Class<C2DM> forClass() {
            return C2DM.class;
        }

        @Override
        public int getCoordinateDimension() {
            return 3;
        }

        @Override
        public C2DM mkPosition(double ... coordinates) {
            return coordinates.length == 0 ? new C2DM() : new C2DM(coordinates[0], coordinates[1], coordinates[2]);
        }

        @Override
        public boolean hasZComponent() {
            return false;
        }

        @Override
        public boolean hasMComponent() {
            return true;
        }

        @Override
        public int getMComponentIndex() {
            return 2;
        }
    }

    public static class CanMakeP2D
    implements PositionFactory<C2D> {
        @Override
        public Class<C2D> forClass() {
            return C2D.class;
        }

        @Override
        public int getCoordinateDimension() {
            return 2;
        }

        @Override
        public C2D mkPosition(double ... coordinates) {
            return coordinates.length == 0 ? new C2D() : new C2D(coordinates[0], coordinates[1]);
        }

        @Override
        public boolean hasZComponent() {
            return false;
        }

        @Override
        public boolean hasMComponent() {
            return false;
        }

        @Override
        public int getMComponentIndex() {
            return -1;
        }
    }
}

