/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.C3D;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.AbstractWktDecoder;
import org.geolatte.geom.codec.CrsWktTokenizer;
import org.geolatte.geom.codec.CrsWktVariant;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.crs.AngularUnit;
import org.geolatte.geom.crs.CartesianCoordinateSystem2D;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CoordinateSystemAxisDirection;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.Datum;
import org.geolatte.geom.crs.Ellipsoid;
import org.geolatte.geom.crs.EllipsoidalAxis;
import org.geolatte.geom.crs.EllipsoidalCoordinateSystem2D;
import org.geolatte.geom.crs.GeocentricCartesianCoordinateReferenceSystem;
import org.geolatte.geom.crs.GeodeticLatitudeCSAxis;
import org.geolatte.geom.crs.GeodeticLongitudeCSAxis;
import org.geolatte.geom.crs.Geographic2DCoordinateReferenceSystem;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.PrimeMeridian;
import org.geolatte.geom.crs.ProjectedCoordinateReferenceSystem;
import org.geolatte.geom.crs.Projection;
import org.geolatte.geom.crs.StraightLineAxis;
import org.geolatte.geom.crs.Unit;

public class CrsWktDecoder
extends AbstractWktDecoder<CoordinateReferenceSystem> {
    private static final CrsWktVariant CRS_TOKENS = new CrsWktVariant();
    private int srid = 0;

    public CrsWktDecoder() {
        super(CRS_TOKENS);
    }

    public CoordinateReferenceSystem<? extends Position> decode(String wkt, int srid) {
        this.srid = srid;
        this.setTokenizer(new CrsWktTokenizer(wkt, this.getWktVariant()));
        this.nextToken();
        return this.decode();
    }

    private CoordinateReferenceSystem<? extends Position> decode() {
        if (this.currentToken == CrsWktVariant.PROJCS) {
            return this.decodeProjectedCrs();
        }
        if (this.currentToken == CrsWktVariant.GEOGCS) {
            return this.decodeGeographicCrs();
        }
        if (this.currentToken == CrsWktVariant.GEOCCS) {
            return this.decodeGeocentricCrs();
        }
        throw new WktDecodeException("Expected Wkt Token PROJCS, GEOGCS or GEOCCS");
    }

    private CoordinateReferenceSystem<C3D> decodeGeocentricCrs() {
        throw new UnsupportedConversionException("Currently not implemented");
    }

    private Geographic2DCoordinateReferenceSystem decodeGeographicCrs() {
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        Datum datum = this.decodeDatum();
        this.matchesElementSeparator();
        PrimeMeridian primem = this.decodePrimem();
        this.matchesElementSeparator();
        Unit unit = this.decodeUnit(false);
        CoordinateSystemAxis[] twinAxes = this.decodeOptionalTwinAxis(unit, Geographic2DCoordinateReferenceSystem.class);
        CrsId cr = this.decodeOptionalAuthority(this.srid);
        this.matchesCloseList();
        Geographic2DCoordinateReferenceSystem system = new Geographic2DCoordinateReferenceSystem(cr, crsName, new EllipsoidalCoordinateSystem2D((EllipsoidalAxis)twinAxes[0], (EllipsoidalAxis)twinAxes[1]));
        system.setDatum(datum);
        system.setPrimeMeridian(primem);
        return system;
    }

    private ProjectedCoordinateReferenceSystem decodeProjectedCrs() {
        List<CrsParameter> parameters;
        Projection projection;
        Unit unit;
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        Geographic2DCoordinateReferenceSystem geogcs = this.decodeGeographicCrs();
        this.matchesElementSeparator();
        if (this.currentToken == CrsWktVariant.UNIT) {
            unit = this.decodeUnit(true);
            projection = this.decodeProjection();
            parameters = this.decodeOptionalParameters();
        } else {
            projection = this.decodeProjection();
            parameters = this.decodeOptionalParameters();
            unit = this.decodeUnit(true);
        }
        CrsId crsId = this.decodeOptionalAuthority(this.srid);
        CoordinateSystemAxis[] twinAxes = this.decodeOptionalTwinAxis(unit, ProjectedCoordinateReferenceSystem.class);
        return new ProjectedCoordinateReferenceSystem(crsId, crsName, geogcs, projection, parameters, new CartesianCoordinateSystem2D((StraightLineAxis)twinAxes[0], (StraightLineAxis)twinAxes[1]));
    }

    private List<CrsParameter> decodeOptionalParameters() {
        ArrayList<CrsParameter> parameters = new ArrayList<CrsParameter>();
        CrsParameter parameter = this.decodeOptionalParameter();
        while (parameter != null) {
            parameters.add(parameter);
            parameter = this.decodeOptionalParameter();
        }
        return parameters;
    }

    private CrsParameter decodeOptionalParameter() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.PARAMETER) {
            return null;
        }
        this.nextToken();
        String name = this.decodeName();
        this.matchesElementSeparator();
        double value = this.decodeNumber();
        this.matchesCloseList();
        return new CrsParameter(name, value);
    }

    private Projection decodeProjection() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.PROJECTION) {
            throw new WktDecodeException("Expected PROJECTION keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return new Projection(crsId, name);
    }

    private <T extends CoordinateReferenceSystem> CoordinateSystemAxis[] decodeOptionalTwinAxis(Unit unit, Class<T> crsClass) {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.AXIS) {
            return this.defaultCRS(unit, crsClass);
        }
        CoordinateSystemAxis[] twinAxes = new CoordinateSystemAxis[2];
        twinAxes[0] = this.decodeAxis(unit, crsClass);
        this.matchesElementSeparator();
        twinAxes[1] = this.decodeAxis(unit, crsClass);
        return twinAxes;
    }

    private <T extends CoordinateReferenceSystem> CoordinateSystemAxis[] defaultCRS(Unit unit, Class<T> crsClass) {
        if (Geographic2DCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new GeodeticLongitudeCSAxis("Lon", (AngularUnit)unit), new GeodeticLatitudeCSAxis("Lat", (AngularUnit)unit)};
        }
        if (ProjectedCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new StraightLineAxis("X", CoordinateSystemAxisDirection.EAST, (LinearUnit)unit), new StraightLineAxis("Y", CoordinateSystemAxisDirection.NORTH, (LinearUnit)unit)};
        }
        if (GeocentricCartesianCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new StraightLineAxis("X", CoordinateSystemAxisDirection.GeocentricX, (LinearUnit)unit), new StraightLineAxis("Y", CoordinateSystemAxisDirection.GeocentricY, (LinearUnit)unit), new StraightLineAxis("Z", CoordinateSystemAxisDirection.GeocentricZ, (LinearUnit)unit)};
        }
        throw new IllegalStateException("Can't create default for CrsRegistry of type " + crsClass.getCanonicalName());
    }

    private <T extends CoordinateReferenceSystem> CoordinateSystemAxis decodeAxis(Unit unit, Class<T> crsClass) {
        if (this.currentToken != CrsWktVariant.AXIS) {
            throw new WktDecodeException("Expected AXIS keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        CoordinateSystemAxisDirection direction = CoordinateSystemAxisDirection.valueOf(this.currentToken.toString());
        this.nextToken();
        this.matchesCloseList();
        if (Geographic2DCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            if (direction.equals((Object)CoordinateSystemAxisDirection.NORTH)) {
                return new GeodeticLatitudeCSAxis(name, (AngularUnit)unit);
            }
            if (direction.equals((Object)CoordinateSystemAxisDirection.EAST)) {
                return new GeodeticLongitudeCSAxis(name, (AngularUnit)unit);
            }
            throw new IllegalStateException("Axis in horizontal Geographic coordinate system is neither latitude, nor longitude");
        }
        if (ProjectedCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            if (direction == CoordinateSystemAxisDirection.UNKNOWN) {
                if (name.equalsIgnoreCase("X") || name.equalsIgnoreCase("Easting")) {
                    return new StraightLineAxis(name, direction, 0, (LinearUnit)unit);
                }
                return new StraightLineAxis(name, direction, 1, (LinearUnit)unit);
            }
            return new StraightLineAxis(name, direction, (LinearUnit)unit);
        }
        if (GeocentricCartesianCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new StraightLineAxis(name, direction, (LinearUnit)unit);
        }
        throw new IllegalStateException("Can't create default for CrsRegistry of type " + crsClass.getCanonicalName());
    }

    private Unit decodeUnit(boolean isLinear) {
        if (this.currentToken != CrsWktVariant.UNIT) {
            throw new WktDecodeException("Expected UNIT keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        double cf = this.decodeNumber();
        this.matchesElementSeparator();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return isLinear ? new LinearUnit(crsId, name, cf) : new AngularUnit(crsId, name, cf);
    }

    private PrimeMeridian decodePrimem() {
        if (this.currentToken != CrsWktVariant.PRIMEM) {
            throw new WktDecodeException("Expected PRIMEM keyword, received " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        double longitude = this.decodeNumber();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return new PrimeMeridian(crsId, name, longitude);
    }

    private Datum decodeDatum() {
        if (this.currentToken != CrsWktVariant.DATUM) {
            throw new WktDecodeException("Expected DATUM token.");
        }
        String datumName = this.decodeName();
        this.matchesElementSeparator();
        Ellipsoid ellipsoid = this.decodeSpheroid();
        double[] toWGS84 = this.decodeOptionalToWGS84();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return new Datum(crsId, ellipsoid, datumName, toWGS84);
    }

    private double[] decodeOptionalToWGS84() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.TOWGS84) {
            return new double[0];
        }
        this.nextToken();
        double[] toWGS = new double[7];
        this.matchesOpenList();
        for (int i = 0; i < 7; ++i) {
            toWGS[i] = this.decodeNumber();
            this.matchesElementSeparator();
        }
        this.matchesCloseList();
        return toWGS;
    }

    private Ellipsoid decodeSpheroid() {
        if (this.currentToken != CrsWktVariant.SPHEROID) {
            throw new WktDecodeException("Expected SPHEROID keyword, but received " + this.currentToken.toString());
        }
        String ellipsoidName = this.decodeName();
        this.matchesElementSeparator();
        double semiMajorAxis = this.decodeNumber();
        this.matchesElementSeparator();
        double inverseFlattening = this.decodeNumber();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return new Ellipsoid(crsId, ellipsoidName, semiMajorAxis, inverseFlattening);
    }

    private CrsId decodeOptionalAuthority(int srid) {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.AUTHORITY) {
            return CrsId.valueOf(srid);
        }
        this.nextToken();
        this.matchesOpenList();
        String authority = this.decodeText();
        this.matchesElementSeparator();
        String value = this.decodeText();
        this.matchesCloseList();
        if (authority.equals("EPSG")) {
            try {
                return new CrsId("EPSG", Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new WktDecodeException("Expected EPSG integer code, received " + value);
            }
        }
        return CrsId.valueOf(srid);
    }

    private String decodeName() {
        this.nextToken();
        this.matchesOpenList();
        return this.decodeText();
    }
}

