/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.ArrayList;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.codec.db.Decoder;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.Decoders;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;

public class GeometryCollectionSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == TypeGeometry.COLLECTION;
    }

    @Override
    Geometry<?> internalDecode(SDOGeometry sdoGeom) {
        ArrayList geometries = new ArrayList();
        for (SDOGeometry elemGeom : sdoGeom.getElementGeometries()) {
            Decoder decoder = Decoders.decoderFor(elemGeom);
            geometries.add(decoder.decode(elemGeom));
        }
        Geometry[] geomArray = new Geometry[geometries.size()];
        return new GeometryCollection(geometries.toArray(geomArray));
    }
}

