/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;

public class SdoMultiLineStringEncoder
extends AbstractSDOEncoder {
    @Override
    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return GeometryType.MULTILINESTRING.equals((Object)geom.getGeometryType());
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SDOGeometry encode(G geom) {
        MultiLineString multiLineString = (MultiLineString)geom;
        int dim = multiLineString.getCoordinateDimension();
        int lrsDim = this.getLRSDim(multiLineString);
        boolean isLrs = lrsDim != 0;
        SDOGType sdoGtype = new SDOGType(dim, lrsDim, TypeGeometry.MULTILINE);
        ElemInfo info = new ElemInfo(multiLineString.getNumGeometries());
        int oordinatesOffset = 1;
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            info.setElement(i, oordinatesOffset, ElementType.LINE_STRAITH_SEGMENTS, 0);
            ordinates = this.addOrdinates(ordinates, this.convertPositionSequence(((LineString)multiLineString.getGeometryN(i)).getPositions()));
            oordinatesOffset = ordinates.length + 1;
        }
        return new SDOGeometry(sdoGtype, geom.getSRID(), null, info, new Ordinates(ordinates));
    }
}

