/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.C3D;
import org.geolatte.geom.C3DM;
import org.geolatte.geom.crs.CartesianCoordinateSystem3DM;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.StraightLineAxis;
import org.geolatte.geom.crs.VerticalStraightLineAxis;

public class CartesianCoordinateSystem3D
extends CoordinateSystem<C3D> {
    private static final List<Integer> REQUIRED_AXIS_NORMAL_ORDER = Arrays.asList(0, 1, 2);

    public CartesianCoordinateSystem3D(StraightLineAxis firstAxis, StraightLineAxis secondAxis, VerticalStraightLineAxis thirdAxis) {
        super(firstAxis, secondAxis, thirdAxis);
        this.checkAxes();
    }

    private void checkAxes() {
        List<Integer> order = this.getAxisNormalOrder();
        if (!order.containsAll(REQUIRED_AXIS_NORMAL_ORDER)) {
            throw new IllegalArgumentException("Require order 0, 1 and 2 axes");
        }
    }

    @Override
    public Class<C3D> getPositionClass() {
        return C3D.class;
    }

    @Override
    public CoordinateSystem<?> merge(OneDimensionCoordinateSystem<?> coordinateSystem) {
        CoordinateSystemAxis axis = coordinateSystem.getAxis();
        return this.extend(axis);
    }

    @Override
    public CoordinateSystem<C3DM> extend(CoordinateSystemAxis axis) {
        if (axis instanceof MeasureStraightLineAxis) {
            return new CartesianCoordinateSystem3DM((StraightLineAxis)this.getAxis(0), (StraightLineAxis)this.getAxis(1), (VerticalStraightLineAxis)this.getAxis(2), (MeasureStraightLineAxis)axis);
        }
        throw new UnsupportedOperationException();
    }
}

