/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.cga;

import org.geolatte.geom.Position;
import org.geolatte.geom.cga.NumericalMethods;

public class Circle {
    final double x;
    final double y;
    final double radius;

    public Circle(double x, double y, double radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    public Circle(Position p0, Position p1, Position p2) {
        this(p0, p1, p2, true);
    }

    public Circle(Position p0, Position p1, Position p2, boolean doCollinearityCheck) {
        if (doCollinearityCheck && NumericalMethods.collinear(p0, p1, p2)) {
            throw new IllegalArgumentException("Positions are collinear in 2D");
        }
        double X1 = p1.getCoordinate(0) - p0.getCoordinate(0);
        double Y1 = p1.getCoordinate(1) - p0.getCoordinate(1);
        double X2 = p2.getCoordinate(0) - p0.getCoordinate(0);
        double Y2 = p2.getCoordinate(1) - p0.getCoordinate(1);
        double areaM = 2.0 * NumericalMethods.determinant(X1, Y1, X2, Y2);
        double sqrL10 = Math.pow(X1, 2.0) + Math.pow(Y1, 2.0);
        double sqrL20 = Math.pow(X2, 2.0) + Math.pow(Y2, 2.0);
        this.x = p0.getCoordinate(0) + (Y2 * sqrL10 - Y1 * sqrL20) / areaM;
        this.y = p0.getCoordinate(1) + (X1 * sqrL20 - X2 * sqrL10) / areaM;
        this.radius = Math.hypot(this.x - p0.getCoordinate(0), this.y - p0.getCoordinate(1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Circle circle = (Circle)o;
        if (Double.compare(circle.radius, this.radius) != 0) {
            return false;
        }
        if (Double.compare(circle.x, this.x) != 0) {
            return false;
        }
        return Double.compare(circle.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Circle{x=" + this.x + ", y=" + this.y + ", radius=" + this.radius + "}";
    }
}

