/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.Arrays;
import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.WkbDialect;

class BaseWkbVisitor<P extends Position>
implements GeometryVisitor<P> {
    private final ByteBuffer output;
    private final WkbDialect dialect;

    BaseWkbVisitor(ByteBuffer byteBuffer, WkbDialect dialect) {
        this.output = byteBuffer;
        this.dialect = dialect;
    }

    ByteBuffer buffer() {
        return this.output;
    }

    ByteBuffer result() {
        this.output.rewind();
        return this.output;
    }

    WkbDialect dialect() {
        return this.dialect;
    }

    @Override
    public void visit(Point<P> geom) {
        this.writeByteOrder(geom, this.output);
        this.writeTypeCodeAndSrid(geom, this.output);
        if (geom.isEmpty()) {
            if (this.dialect.emptyPointAsNaN()) {
                double[] co = new double[geom.getCoordinateDimension()];
                Arrays.fill(co, Double.NaN);
                this.writePoint(co, this.output);
            } else {
                this.output.putUInt(0L);
            }
        } else {
            this.writePoints(geom.getPositions(), geom.getCoordinateDimension(), this.output);
        }
    }

    @Override
    public void visit(LineString<P> geom) {
        this.writeByteOrder(geom, this.output);
        this.writeTypeCodeAndSrid(geom, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.output.putUInt(geom.getNumPositions());
            this.writePoints(geom.getPositions(), geom.getCoordinateDimension(), this.output);
        }
    }

    @Override
    public void visit(Polygon<P> geom) {
        this.writeByteOrder(geom, this.output);
        this.writeTypeCodeAndSrid(geom, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.writeNumRings(geom, this.output);
            for (LinearRing<P> ring : geom) {
                this.writeRing(ring);
            }
        }
    }

    @Override
    public <G extends Geometry<P>> void visit(AbstractGeometryCollection<P, G> geom) {
        this.writeByteOrder(geom, this.output);
        this.writeTypeCodeAndSrid(geom, this.output);
        this.output.putUInt(geom.getNumGeometries());
    }

    protected void writeRing(LinearRing<P> geom) {
        this.output.putUInt(geom.getNumPositions());
        this.writePoints(geom.getPositions(), geom.getCoordinateDimension(), this.output);
    }

    protected void writeNumRings(Polygon<P> geom, ByteBuffer byteBuffer) {
        byteBuffer.putUInt(geom.isEmpty() ? 0L : (long)(geom.getNumInteriorRing() + 1));
    }

    protected void writePoint(double[] coordinates, ByteBuffer output) {
        for (double coordinate : coordinates) {
            output.putDouble(coordinate);
        }
    }

    protected void writePoints(PositionSequence<P> points, int coordinateDimension, ByteBuffer output) {
        double[] coordinates = new double[coordinateDimension];
        for (int i = 0; i < points.size(); ++i) {
            points.getCoordinates(i, coordinates);
            this.writePoint(coordinates, output);
        }
    }

    protected void writeByteOrder(Geometry<P> geom, ByteBuffer output) {
        output.put(output.getByteOrder().byteValue());
    }

    protected void writeTypeCodeAndSrid(Geometry<P> geometry, ByteBuffer output) {
        long typeCode = this.dialect.geometryTypeCode(geometry);
        output.putUInt(typeCode);
    }
}

