/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.geolatte.geom.codec.db.oracle.ConnectionFinder;

public class DefaultConnectionFinder
implements ConnectionFinder {
    private static final Class<?> ORACLE_CONNECTION_CLASS;
    private static final Class<?> ORACLE_CONNECTION_INTERFACE;

    @Override
    public Connection find(Connection con) {
        if (con == null) {
            return null;
        }
        if (ORACLE_CONNECTION_CLASS.isInstance(con)) {
            return con;
        }
        try {
            if (con.isWrapperFor(ORACLE_CONNECTION_INTERFACE)) {
                return (Connection)con.unwrap(ORACLE_CONNECTION_INTERFACE);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (Method method : con.getClass().getMethods()) {
            if (!Connection.class.isAssignableFrom(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
            try {
                method.setAccessible(true);
                Connection oc = this.find((Connection)method.invoke((Object)con, new Object[0]));
                if (oc == null) {
                    throw new RuntimeException(String.format("Tried retrieving OracleConnection from %s using method %s, but received null.", con.getClass().getCanonicalName(), method.getName()));
                }
                return oc;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Illegal access on executing method %s when finding OracleConnection", method.getName()));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(String.format("Invocation exception on executing method %s when finding OracleConnection", method.getName()));
            }
        }
        throw new RuntimeException("Couldn't get at the OracleSpatial Connection object from the PreparedStatement.");
    }

    static {
        try {
            ORACLE_CONNECTION_CLASS = Class.forName("oracle.jdbc.driver.OracleConnection");
            ORACLE_CONNECTION_INTERFACE = Class.forName("oracle.jdbc.OracleConnection");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find Oracle JDBC Driver on classpath.");
        }
    }
}

