/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.Encoders;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;

public class GeometryCollectionSdoEncoder
extends AbstractSDOEncoder {
    @Override
    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return GeometryType.GEOMETRYCOLLECTION.equals((Object)geom.getGeometryType());
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SDOGeometry encode(G geom) {
        AbstractGeometryCollection collection = (AbstractGeometryCollection)geom;
        SDOGeometry[] sdoElements = new SDOGeometry[collection.getNumGeometries()];
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            Object component = collection.getGeometryN(i);
            sdoElements[i] = Encoders.encode(component);
        }
        SDOGeometry ccollect = this.join(sdoElements);
        return ccollect;
    }

    public SDOGeometry join(SDOGeometry[] sdoElements) {
        if (sdoElements == null || sdoElements.length == 0) {
            return new SDOGeometry(new SDOGType(2, 0, SdoGeometryType.COLLECTION), 0, null, null, null);
        }
        SDOGeometry firstElement = sdoElements[0];
        int dim = firstElement.getGType().getDimension();
        int lrsDim = firstElement.getGType().getLRSDimension();
        int srid = firstElement.getSRID();
        SDOGType gtype = new SDOGType(dim, lrsDim, SdoGeometryType.COLLECTION);
        int ordinatesOffset = 1;
        ElemInfo resultInfo = null;
        Ordinates resultOrdinates = null;
        for (int i = 0; i < sdoElements.length; ++i) {
            ElemInfo element = sdoElements[i].getInfo();
            Double[] ordinates = sdoElements[i].getOrdinates().getOrdinateArray();
            if (element == null || element.getNumTriplets() <= 0) continue;
            int shift = ordinatesOffset - element.getOrdinatesOffset(0);
            SDOGeometry.shiftOrdinateOffset(element, shift);
            resultInfo = this.addElementInfo(resultInfo, element);
            resultOrdinates = this.addOrdinates(resultOrdinates, ordinates);
            ordinatesOffset += ordinates.length;
        }
        return new SDOGeometry(gtype, srid, null, resultInfo, resultOrdinates);
    }
}

