/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.List;
import java.util.stream.Collectors;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class MultiLineSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == SdoGeometryType.MULTILINE;
    }

    @Override
    Geometry<?> internalDecode() {
        return this.decode(this.nativeGeom.getGType(), this.nativeGeom.getElements(), this.nativeGeom.getCoordinateReferenceSystem());
    }

    @Override
    protected <P extends Position> Geometry<P> decode(SDOGType gtype, List<Element> elements, CoordinateReferenceSystem<P> crs) {
        List<LineString> strings = elements.stream().map(el -> el.linearizedPositions(gtype, crs)).map(ps -> new LineString(ps, crs)).collect(Collectors.toList());
        return strings.isEmpty() ? new MultiLineString<P>(crs) : new MultiLineString(strings.toArray(new LineString[0]));
    }
}

